﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 采购建议单
    /// </summary>
    public class dc_auto_purchase_advise
    {
        public int id { get; set; }

        /// <summary>
        /// 流水号
        /// </summary>
        public string no { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 采购建议单号
        /// </summary>
        public string buy_sys_plan_no { get; set; }

        public DateTime? push_time { get; set; }
    }

    /// <summary>
    /// 采购建议流水
    /// </summary>
    public class dc_auto_purchase_advise_detailed
    {
        public int id { get; set; }

        /// <summary>
        /// sku
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }
        /// <summary>
        /// 系统建议采购数量
        /// </summary>
        public decimal quantity_init_advise { get; set; }
        /// <summary>
        /// 实际下单数量
        /// </summary>
        public decimal quantity_actual { get; set; }

        /// <summary>
        /// 主表ID
        /// </summary>
        public int main_id { get; set; }

        /// <summary>
        /// 销量趋势预测公式y = kx + b
        /// </summary>
        public string forecast_formula { get; set; }

        /// <summary>
        /// 销量预测公式
        /// </summary>
        public string fit_forecast_formula { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 质检天数
        /// </summary>
        public int inspection_delivery { get; set; }

        /// <summary>
        /// 调拨天数
        /// </summary>
        public int transfer_delivery { get; set; }

        public int sales_upper_limit { get; set; }

        /// <summary>
        /// 是否推送
        /// </summary>
        public int ispush { get; set; }

        /// <summary>
        /// 采购单类型
        /// </summary>
        public int type { get; set; }

        /// <summary>
        /// 系统建议数量
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string product_inner_code { get; set; }
        /// <summary>
        /// 商品建议下单数
        /// </summary>
        public decimal goods_quantity_init_advise { get; set; }

        /// <summary>
        /// 商品MOQ
        /// </summary>
        public int goods_moq { get; set; }

        /// <summary>
        /// 商品下所有sku
        /// </summary>
        public string good_sku_codes { get; set; }

        /// <summary>
        /// 商品的最近14日日均销量
        /// </summary>
        public decimal goods_history_fourteenday_sales { get; set; }

        /// <summary>
        /// 产品的最近14日日均
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        public int suppliers_id { get; set; }
    }

    public class dc_auto_purchase_advise_detailed_buy_dto: dc_auto_purchase_advise_detailed
    {
        /// <summary>
        /// 单价
        /// </summary>
        public decimal unit_price { get; set; }
    }

    public class dc_auto_purchase_advise_detailed_dto : dc_auto_purchase_advise_detailed
    {
        public string warehouse_name { get; set; }

        public string sku_name { get; set; }

        public DateTime create_time { get; set; }

        public string create_time_str { get { return create_time.ToString("yyyy-MM-dd"); } }


    }

    public class dc_auto_purchase_advise_detailed_time_dto : dc_auto_purchase_advise_detailed
    {
        public DateTime create_time { get; set; }
    }

    public class dc_auto_purchase_advise_search_dto
    {
        public DateTime? start_date { get; set; }

        public DateTime? end_date { get; set; }

        /// <summary>
        /// 是否推送
        /// </summary>
        public bool? has_push { get; set; }

        /// <summary>
        /// 预计是否断货
        /// </summary>
        public bool? is_outofstock { get; set; }
    }
    public class dc_auto_purchase_advise_detailed_search_dto
    {
        /// <summary>
        /// 主表ID
        /// </summary>
        public int main_id { get; set; }

        public string sku { get; set; }

        public string warehouse_code { get; set; }
        public DateTime? start_date { get; set; }

        public DateTime? end_date { get; set; }
        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }

        /// <summary>
        /// 是否推送
        /// </summary>
        public bool? ispush { get; set; }

        public int? type { get; set; }

        /// <summary>
        /// 采购员
        /// </summary>
        public string purchase_user { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier_name { get; set; }

        public string product_inner_code { get; set; }
    }

}
