﻿using System;
using System.Collections.Generic;
using System.Text;
using Dapper;
using AutoTurnOver.Models;

namespace AutoTurnOver.DB
{
    public class AutoOrder : connectionHelper
    {

        /// <summary>
        /// 获取订单列表
        /// </summary>
        /// <param name="m">条件model</param>
        /// <param name="offset">mysql查询偏移量</param>
        /// <param name="limit">每页记录数</param>
        /// <param name="total">符合条件的记录数</param>
        /// <returns></returns>
        public static List<dc_auto_order> List(Condition_AutoOrder m,int offset, int limit, ref int total)
        {
            var sql = @"select t1.* from dc_auto_order as t1
left join dc_base_warehouse as t3 on t1.warehouse_code = t3.warehouse_code
where status!=-1 ";

            if (!string.IsNullOrWhiteSpace(m.warehousetype))
            {
                sql += " and t3.hq_type=" + $"'{m.warehousetype}'";
            }
            if (m.warehousearea > 0)
            {
                sql += " and t3.area_id=" + m.warehousearea;
            }
            if (!string.IsNullOrWhiteSpace(m.sku))
            {
                sql += " and t1.bailun_sku like '%" + m.sku + "%'";
            }

            if (!string.IsNullOrWhiteSpace(m.warehousecode))
            {
                sql += " and t1.warehouse_code='" + m.warehousecode + "'";
            }

            sql += " order by t1.createtime desc";

            try
            {
                var obj = _connection.Page<dc_auto_order>(offset, limit, sql, ref total);

                return obj.AsList();
            }
            catch (Exception)
            {
                return new List<dc_auto_order>();
            }
        }
    }
}
