﻿using System;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// aims普货周缺货数据明细
    /// </summary>
    public class dc_auto_week_shortage_details
    {
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 百伦sku
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 入库时间
        /// </summary>
        public DateTime? warehousing_time { get; set; }

        /// <summary>
        /// 历史采购数量
        /// </summary>
        public int historical_purchase_quantity { get; set; }

        /// <summary>
        /// 历史销售数量
        /// </summary>
        public int historical_sales_quantity { get; set; }

        /// <summary>
        /// 过去7天日均
        /// </summary>
        public decimal seven_days_average { get; set; }

        /// <summary>
        /// 缺货时间
        /// </summary>
        public DateTime? stockout_time { get; set; }

        /// <summary>
        /// pds开发竞品item
        /// </summary>
        public string pds_item_id { get; set; }

        /// <summary>
        /// ana市场模糊7日均
        /// </summary>
        public decimal ana_seven_days_average { get; set; }

        /// <summary>
        /// 第一销售平台7日均
        /// </summary>
        public decimal first_sales_platform_average { get; set; }

        /// <summary>
        /// 第二销售平台7日均
        /// </summary>
        public decimal second_sales_platform_average { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal safety_stock { get; set; }

        /// <summary>
        /// 数据开始时间
        /// </summary>
        public DateTime start_date { get; set; }

        /// <summary>
        /// 数据结束时间
        /// </summary>
        public DateTime end_date { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_date_time { get; set; }

        /// <summary>
        /// 最后同步时间
        /// </summary>
        public DateTime? last_synch_time { get; set; }
    }
}
