﻿using System;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// aims-本周新增冗余明细
    /// </summary>
    public class dc_auto_week_redundancy_details
    {
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 入库时间
        /// </summary>
        public DateTime? warehousing_time { get; set; }

        /// <summary>
        /// 过去7天日均
        /// </summary>
        public int seven_days_average { get; set; }

        /// <summary>
        /// 总库存数
        /// </summary>
        public int total_inventory { get; set; }

        /// <summary>
        /// 总库存金额
        /// </summary>
        public decimal total_inventory_amount { get; set; }

        /// <summary>
        /// 冗余数
        /// </summary>
        public int redundant_number { get; set; }

        /// <summary>
        /// 冗余金额
        /// </summary>
        public decimal redundancy_amount { get; set; }

        /// <summary>
        /// 冗余发生日期
        /// </summary>
        public DateTime? redundancy_occurrence_date { get; set; }

        /// <summary>
        /// 数据开始时间
        /// </summary>
        public DateTime start_date { get; set; }

        /// <summary>
        /// 数据结束时间
        /// </summary>
        public DateTime end_date { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_date_time { get; set; }

        /// <summary>
        /// 最后同步时间
        /// </summary>
        public DateTime? last_synch_time { get; set; }
    }
}
