﻿using AutoTurnOver.Models.ApiDto;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Linq;

using static AutoTurnOver.Models.dc_base_stock_dto;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// sku自动周转
    /// </summary>
    public partial class dc_auto_turnover
    {
        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public int id { get; set; }

        /// <summary>
        /// 供应链长度的配置销量明细
        /// </summary>
        public string sales_day_config_details { get; set; }

        /// <summary>
        /// 建议单单号
        /// </summary>
        [Description(@"建议单单号")]
        public string purchase_advice_id { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        [Description(@"SKU")]
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [Description(@"仓库编码")]
        public string warehouse_code { get; set; }

        /// <summary>
        /// 计算的自动采购建议(算上备货销量之后的)
        /// </summary>
        [Description(@"计算的自动采购建议(算上备货销量之后的)")]
        public decimal quantity_init_advise { get; set; }

        /// <summary>
        /// 最小订单数量
        /// </summary>
        [Description(@"最小订单数量")]
        public int quantity_minimum_order { get; set; }

        /// <summary>
        /// 跟MOQ对比后最终的的自动采购建议
        /// </summary>
        [Description(@"跟MOQ对比后最终的的自动采购建议")]
        public decimal quantity_final_advise { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        [Description(@"仓库名称")]
        public string warehouse_name { get; set; }

        /// <summary>
        /// 活动促销数量
        /// </summary>
        [Description(@"活动促销数量")]
        public int quantity_promotion { get; set; }

        /// <summary>
        /// 实际库存数量
        /// </summary>
        [Description(@"实际库存数量")]
        public int quantity_inventory { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        [Description(@"调拨在途")]
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        [Description(@"采购在途")]
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 周转天数,，国内仓：sku供应商交期+2天质检入库时间，调拨：国外仓 sku供应商交期+2天质检入库时间+7天调拨交运
        /// </summary>
        [Description(@"周转天数,，国内仓：sku供应商交期+2天质检入库时间，调拨：国外仓 sku供应商交期+2天质检入库时间+7天调拨交运")]
        public int turnover_days { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        [Description(@"安全库存")]
        public decimal quantity_safe_inventory { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [Description(@"备注")]
        public string remark { get; set; }

        /// <summary>
        /// 数据中心-创建时间
        /// </summary>
        [Description(@"数据中心-创建时间")]
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 数据中心-更新时间
        /// </summary>
        [Description(@"数据中心-更新时间")]
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 正常为0, 缺货为1
        /// </summary>
        [Description(@"正常为0, 缺货为1")]
        public int status { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        [Description(@"缺货数量")]
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// SKU标题
        /// </summary>
        [Description(@"SKU标题")]
        public string sku_title { get; set; }

        /// <summary>
        /// 与dc_auto_config_promotion的id关联,以逗号分隔
        /// </summary>
        [Description(@"与dc_auto_config_promotion的id关联,以逗号分隔")]
        public string promotions { get; set; }

        /// <summary>
        /// 供应商交期天数
        /// </summary>
        [Description(@"供应商交期天数")]
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 库存消化(可用)天数
        /// </summary>
        [Description(@"库存消化(可用)天数")]
        public int inventory_available_days { get; set; }

        /// <summary>
        /// 周转期内入库数
        /// </summary>
        [Description(@"周转期内入库数")]
        public int quantity_inbound { get; set; }

        /// <summary>
        /// 预测第一日销量（日均)
        /// </summary>
        [Description(@"预测第一日销量（日均)")]
        public decimal forecast_oneday_sales { get; set; }

        /// <summary>
        /// 预测第七日销量（日均)
        /// </summary>
        [Description(@"预测第七日销量（日均)")]
        public decimal forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 预测第十四日销量（日均)
        /// </summary>
        [Description(@"预测第十四日销量（日均)")]
        public decimal forecast_fourteenday_sales { get; set; }

        /// <summary>
        /// 七天实际销量+预测销量
        /// </summary>
        [Description(@"七天实际销量+预测销量")]
        public string sales_details { get; set; }

        /// <summary>
        /// 七天实际入库+预测入库
        /// </summary>
        [Description(@"七天实际入库+预测入库")]
        public string inbound_details { get; set; }

        /// <summary>
        /// 七天实际库存+预测库存
        /// </summary>
        [Description(@"七天实际库存+预测库存")]
        public string inventory_details { get; set; }

        /// <summary>
        /// 七天实际断货+预测断货
        /// </summary>
        [Description(@"七天实际断货+预测断货")]
        public string short_supply_details { get; set; }

        /// <summary>
        /// 预测建议
        /// </summary>
        [Description(@"预测建议")]
        public string advised_details { get; set; }

        /// <summary>
        /// 销量上限
        /// </summary>
        [Description(@"销量上限")]
        public decimal sales_upper_limit { get; set; }

        /// <summary>
        /// 供应商平均逾期
        /// </summary>
        [Description(@"供应商平均逾期")]
        public decimal average_overdue { get; set; }

        /// <summary>
        /// 供应商平均交期
        /// </summary>
        [Description(@"供应商平均交期")]
        public int average_supplier_delivery { get; set; }

        /// <summary>
        /// 调拨头程天数-配置
        /// </summary>
        [Description(@"调拨头程天数-配置")]
        public int transfer_config_delivery { get; set; }

        /// <summary>
        /// 调拨打包天数-配置
        /// </summary>
        [Description(@"调拨打包天数-配置")]
        public int transfer_bale_config_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数-配置
        /// </summary>
        [Description(@"海外仓入库天数-配置")]
        public int abroad_inbound_config_delivery { get; set; }

        /// <summary>
        /// 质检入库天数-配置
        /// </summary>
        [Description(@"质检入库天数-配置")]
        public int inspection_config_delivery { get; set; }

        /// <summary>
        /// 质检入库天数-最终取值
        /// </summary>
        [Description(@"质检入库天数-最终取值")]
        public int inspection_delivery { get; set; }

        /// <summary>
        /// 调拨头程天数-最终取值
        /// </summary>
        [Description(@"调拨头程天数-最终取值")]
        public int transfer_delivery { get; set; }

        /// <summary>
        /// 调拨头程天数-最终取值来源（ lms、aims配置、空运切货）
        /// </summary>
        [Description(@"调拨头程天数-最终取值来源（ lms、aims配置、空运切货）")]
        public string transfer_delivery_source { get; set; }

        /// <summary>
        /// 调拨打包天数-最终取值
        /// </summary>
        [Description(@"调拨打包天数-最终取值")]
        public int transfer_bale_delivery { get; set; }

        /// <summary>
        /// 调拨打包天数-最终取值来源（ lms、aims配置、空运切货）
        /// </summary>
        [Description(@"调拨打包天数-最终取值来源（ lms、aims配置、空运切货）")]
        public string transfer_bale_delivery_source { get; set; }

        /// <summary>
        /// 海外仓入库天数-最终取值
        /// </summary>
        [Description(@"海外仓入库天数-最终取值")]
        public int abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数-最终取值来源（ lms、aims配置、空运切换）
        /// </summary>
        [Description(@"海外仓入库天数-最终取值来源（ lms、aims配置、空运切换）")]
        public string abroad_inbound_delivery_source { get; set; }

        /// <summary>
        /// 补充销量, 当日销量
        /// </summary>
        [Description(@"补充销量, 当日销量")]
        public decimal supplementary_sales { get; set; }

        /// <summary>
        /// 周转期内总销量
        /// </summary>
        [Description(@"周转期内总销量")]
        public decimal turnover_sales { get; set; }

        /// <summary>
        /// 周转期内总入库
        /// </summary>
        [Description(@"周转期内总入库")]
        public decimal turnover_inbound { get; set; }

        /// <summary>
        /// 过去7日销量（日均)
        /// </summary>
        [Description(@"过去7日销量（日均)")]
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日销量（日均)
        /// </summary>
        [Description(@"过去14日销量（日均)")]
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30日销量（日均)
        /// </summary>
        [Description(@"过去30日销量（日均)")]
        public decimal history_thirtyday_sales { get; set; }

        /// <summary>
        /// 预测销量及说明
        /// </summary>
        [Description(@"预测销量及说明")]
        public string sales_explain_details { get; set; }

        /// <summary>
        /// 预测周转期内平均销量
        /// </summary>
        [Description(@"预测周转期内平均销量")]
        public decimal forecast_turnoverday_sales { get; set; }

        /// <summary>
        /// 备货天数的额外销量
        /// </summary>
        [Description(@"备货天数的额外销量")]
        public decimal stock_up_sales { get; set; }

        /// <summary>
        /// 算备货销量前的初始建议数
        /// </summary>
        [Description(@"算备货销量前的初始建议数")]
        public decimal quantity_begin_advise { get; set; }

        /// <summary>
        /// 备货天数
        /// </summary>
        [Description(@"备货天数")]
        public int stock_up_days { get; set; }

        /// <summary>
        /// 先款后货情况供应商交期加的天数
        /// </summary>
        [Description(@"先款后货情况供应商交期加的天数")]
        public int payment_before_delivery { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        [Description(@"商品编码")]
        public string product_code { get; set; }

        /// <summary>
        /// 内部商品编码
        /// </summary>
        [Description(@"内部商品编码")]
        public string product_inner_code { get; set; }

        /// <summary>
        /// 分类id
        /// </summary>
        [Description(@"分类id")]
        public int bailun_category_id { get; set; }

        /// <summary>
        /// 采购员名称
        /// </summary>
        [Description(@"采购员名称")]
        public string buyer_name { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        [Description(@"供应商")]
        public string suppliers_name { get; set; }

        /// <summary>
        /// Ebay过去7日销量（日均)
        /// </summary>
        [Description(@"Ebay过去7日销量（日均)")]
        public decimal history_sevenday_sales_ebay { get; set; }

        /// <summary>
        /// Ebay过去14日销量（日均)
        /// </summary>
        [Description(@"Ebay过去14日销量（日均)")]
        public decimal history_fourteenday_sales_ebay { get; set; }

        /// <summary>
        /// Ebay过去30日销量（日均)
        /// </summary>
        [Description(@"Ebay过去30日销量（日均)")]
        public decimal history_thirtyday_sales_ebay { get; set; }

        /// <summary>
        /// aliexpress过去7日销量（日均)
        /// </summary>
        [Description(@"aliexpress过去7日销量（日均)")]
        public decimal history_sevenday_sales_aliexpress { get; set; }

        /// <summary>
        /// aliexpress过去14日销量（日均)
        /// </summary>
        [Description(@"aliexpress过去14日销量（日均)")]
        public decimal history_fourteenday_sales_aliexpress { get; set; }

        /// <summary>
        /// aliexpress过去30日销量（日均)
        /// </summary>
        [Description(@"aliexpress过去30日销量（日均)")]
        public decimal history_thirtyday_sales_aliexpress { get; set; }

        /// <summary>
        /// 日均加权销量
        /// </summary>
        [Description(@"日均加权销量")]
        public decimal daily_weighted_sales { get; set; }

        /// <summary>
        /// 原始初始建议
        /// </summary>
        [Description(@"原始初始建议")]
        public int? original_quantity_init_advise { get; set; }

        /// <summary>
        /// 是否有修改了建议数
        /// </summary>
        [Description(@"是否有修改了建议数")]
        public int? is_modify_quantity_init_advise { get; set; }

        /// <summary>
        /// dc_auto_jit_tag , id
        /// </summary>
        [Description(@"dc_auto_jit_tag , id")]
        public int tag_id { get; set; }

        /// <summary>
        /// 仓库类型
        /// </summary>
        [Description(@"仓库类型")]
        public string hq_type { get; set; }

        /// <summary>
        /// amazon过去7日销量（日均)
        /// </summary>
        [Description(@"amazon过去7日销量（日均)")]
        public decimal history_sevenday_sales_amazon { get; set; }

        /// <summary>
        /// amazon过去14日销量（日均)
        /// </summary>
        [Description(@"amazon过去14日销量（日均)")]
        public decimal history_fourteenday_sales_amazon { get; set; }

        /// <summary>
        /// amazon过去30日销量（日均)
        /// </summary>
        [Description(@"amazon过去30日销量（日均)")]
        public decimal history_thirtyday_sales_amazon { get; set; }

        /// <summary>
        /// 命中的销量预测规则id
        /// </summary>
        [Description(@"命中的销量预测规则id")]
        public int? dc_auto_sales_forecast_config_id { get; set; }

        /// <summary>
        /// 是否断货，1：是，0：否 （废弃）
        /// </summary>
        [Description(@"是否断货，1：是，0：否 （废弃）")]
        public int? is_out_stock { get; set; }

        /// <summary>
        /// 销量预测公式
        /// </summary>
        [Description(@"销量预测公式")]
        public string sales_details_formula { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public int? dc_auto_sales_forecast_stage_config_id { get; set; }

        /// <summary>
        /// 销量公式名字
        /// </summary>
        [Description(@"销量公式名字")]
        public string dc_auto_sales_forecast_title { get; set; }

        /// <summary>
        /// 默认发送的头程渠道运输方式
        /// </summary>
        [Description(@"默认发送的头程渠道运输方式")]
        public string head_transport_type { get; set; }

        /// <summary>
        /// 默认发送的头程渠道类型
        /// </summary>
        [Description(@"默认发送的头程渠道类型")]
        public string head_transport_logistics_code { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public int? auto_replace_logistics_task_id { get; set; }

        /// <summary>
        /// 首次出单日期
        /// </summary>
        [Description(@"首次出单日期")]
        public DateTime? first_order_date { get; set; }

        /// <summary>
        /// dc_base_oms_sku.bailun_order_id
        /// </summary>
        [Description(@"dc_base_oms_sku.bailun_order_id")]
        public string first_order_bailun_order_id { get; set; }

        /// <summary>
        /// 最新30天 日均出单次数
        /// </summary>
        [Description(@"最新30天 日均出单次数")]
        public decimal? orders_avg { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public string adv_uid { get; set; }

        /// <summary>
        /// 采购平均下单天数
        /// </summary>
        [Description(@"采购平均下单天数")]
        public int purchase_create_order_days { get; set; }

        /// <summary>
        /// 启航天数-最终取值
        /// </summary>
        [Description(@"启航天数-最终取值")]
        public int transfer_sail_days { get; set; }

        /// <summary>
        /// 调拨下单天数
        /// </summary>
        [Description(@"调拨下单天数")]
        public int transfer_order_days { get; set; }


        public string bailun_sku_warehouse_code { get; set; }

        /// <summary>
        /// Walmart 过去7日销量（日均) 
        /// </summary>
        public decimal history_sevenday_sales_walmart { get; set; }
        /// <summary>
        /// Walmart 过去14日销量（日均)
        /// </summary>
        public decimal history_fourteenday_sales_walmart { get; set; }
        /// <summary>
        /// Walmart 过去30日销量（日均)
        /// </summary>
        public decimal history_thirtyday_sales_walmart { get; set; }

        /// <summary>
        /// shopify 过去7日销量（日均) 
        /// </summary>
        [Description(@"shopify过去7日销量（日均)")]
        public decimal history_sevenday_sales_shopify { get; set; }
        /// <summary>
        /// shopify 过去14日销量（日均)
        /// </summary>
        [Description(@"shopify过去14日销量（日均)")]
        public decimal history_fourteenday_sales_shopify { get; set; }
        /// <summary>
        /// shopify 过去30日销量（日均)
        /// </summary>
        [Description(@"shopify过去30日销量（日均)")]
        public decimal history_thirtyday_sales_shopify { get; set; }

        /// <summary>
        /// FBA平台asin
        /// </summary>
        public string fba_asin { get; set; }

        /// <summary>
        /// FBA备注销售
        /// </summary>
        public string fba_sale_remark { get; set; }
        /// <summary>
        /// FBA 预计 断货时间（等于可用/加权日均得出的天数 加上当前日期 得出 预计缺货日期）
        /// </summary>
        public DateTime? fba_out_of_stock_predict_time { get; set; }

        /// <summary>
        /// FBA最近即将入库数量（ 调拨在途里面的预计入库时间里面最早的那一单的数量 ）
        /// </summary>
        public int? fba_put_in_qty { get; set; }

        /// <summary>
        /// FBA最近即将入库时间（ 调拨在途里面的预计入库时间里面最早的那一单的时间）
        /// </summary>
        public DateTime? fba_put_in_time { get; set; }

        /// <summary>
        /// FBA是否需要空运（预计断货时间距离最近即将入库时间超过10天）
        /// </summary>
        public bool? fba_need_airlift { get; set; }
    }

    public class ana_search_dto : Condition_AutoTurnOver
    {
        [Description("页码")]
        public int page { get; set; }
        [Description("分页大小")]
        public int rows { get; set; }
    }
    public class Condition_AutoTurnOver
    {

        public bool isSum { get; set; }
        [Description("sku标签")]
        public string sku_label { get; set; }

        [Description("待调拨数量（最小）")]
        public int? not_trans_count_min { get; set; }
        [Description("待调拨数量（最大）")]
        public int? not_trans_count_max { get; set; }

        [Description("sku")]
        public string bailun_sku { get; set; }

        [Description("采购员")]
        public string buyer_name { get; set; }

        [Description("供应商")]
        public string supplier_name { get; set; }

        [Description("是否侵权")]
        public int? has_tort { get; set; }



        /// <summary>
        /// 仓库编码
        /// </summary>
        [Description("仓库编码")]
        public string warehouse_code { get; set; }

        /// <summary>
        /// 是否缺货
        /// </summary>
        [Description("是否缺货")]
        public int? out_of_stock { get; set; }

        /// <summary>
        /// 是否冗余
        /// </summary>
        [Description("是否冗余")]
        public int? redundancy { get; set; }

        [Description("仓库类型")]
        public string warehousetype { get; set; }

        [Description("仓库国家")]
        public int? warehousearea { get; set; }

        /// <summary>
        /// 是否有配置缺失
        /// </summary>
        [Description("是否有配置缺失")]
        public bool? hasDefectConfig { get; set; }

        /// <summary>
        /// 搜索关键词
        /// </summary>
        [Description("搜索关键词")]
        public string key_words { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        //[Description("查询类型")]
        public int? searchType { get; set; }

        /// <summary>
        /// 是否建议下单
        /// </summary>
        [Description("是否建议下单")]
        public bool? hasAadvise { get; set; }

        /// <summary>
        /// 监控状态 
        /// 1= 停止监控
        /// 0 = 开启监控
        /// </summary>
        [Description("监控状态")]
        public int? monitor_status { get; set; }

        [Description("回货监控状态")]
        public int? returngoodspush_state { get; set; }

        /// <summary>
        ///百伦分类
        /// </summary>
        [Description("百伦分类")]
        public string categoryIds { get; set; }

        public List<bailun_category_new_dto> categoryModels { get; set; }

        [Description("实际库存（最小）")]
        public int? quantity_inventory_min { get; set; }

        [Description("实际库存（最大）")]
        public int? quantity_inventory_max { get; set; }

        [Description("缺货数量（最小）")]
        public int? quantity_out_stock_min { get; set; }

        [Description("缺货数量（最大）")]
        public int? quantity_out_stock_max { get; set; }

        [Description("昨日销量（最小）")]
        public int? oneday_sales_min { get; set; }

        [Description("昨日销量（最大）")]
        public int? oneday_sales_max { get; set; }

        //[Description("日均类型")]
        public int? avg_type { get; set; }

        [Description("日均（最小）")]
        public int? avg_sales_min { get; set; }

        [Description("日均（最大）")]
        public int? avg_sales_max { get; set; }


        [Description("产品类型")]
        public string product_type { get; set; }
    }

    public class dc_auto_turnover_Extend : dc_auto_turnover
    {
        /// <summary>
        ///昨日销量
        /// </summary>
        public int oneday_sales { get; set; }

        /// <summary>
        /// 预测明日销量
        /// </summary>
        public int forecast_oneday_sales2 { get; set; }

        /// <summary>
        /// 商品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        public string suppliers_name { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 百伦分类
        /// </summary>
        public string bailun_category_name { get; set; }

        /// <summary>
        /// 是否停止监控
        /// </summary>
        public int monitor_status { get; set; }

        public string supplier_name { get; set; }


        public string buyer_name { get; set; }

        /// <summary>
        /// 交期异常
        /// </summary>
        public int? delivery_days_error { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        /// <summary>
        /// 实时库存
        /// </summary>
        public decimal? usable_stock { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal? shipped_stock { get; set; }

        /// <summary>
        /// 供应链链接
        /// </summary>
        public string suppliers_link { get; set; }

        public DateTime? develop_time { get; set; }

        public string has_tort { get; set; }
    }

    public class dc_auto_turnover_list_dto
    {
        /// <summary>
        /// 最近7天的订单数量
        /// </summary>
        public int? orders_7 { get; set; }
        /// <summary>
        /// 预测日均销量
        /// </summary>
        public decimal forecast_average_day
        {
            get
            {
                return turnover_days <= 0 ? 0 : Math.Round(turnover_sales / turnover_days, 2);
            }
        }
        /// <summary>
        /// 库存可卖天数
        /// </summary>
        public int stock_use_days
        {
            get
            {
                return forecast_average_day <=0?0: (int)Math.Ceiling((usable_stock??0) / forecast_average_day);
            }
        }
        public  string sales_day_config_details { get; set; }
        private List<int> _sales_day_config_details_list;
        public List<int> sales_day_config_details_list { get
            {
                if (_sales_day_config_details_list == null && !string.IsNullOrWhiteSpace(sales_day_config_details))
                {
                    _sales_day_config_details_list = JsonConvert.DeserializeObject<List<decimal>>(sales_day_config_details).Select(s => (int)Math.Ceiling(s)).ToList(); ;
                }
                return _sales_day_config_details_list;
            } }
        public string full_stock_use_days_turnover_sales {
            get
            {
                try
                {
                    var details = sales_day_config_details_list;
                    return details.Where((s, index) => index <= (full_stock_use_days - 1)).Sum().ToString();
                }
                catch (Exception ex)
                {
                    return "";
                }
               
            }
        } 

        /// <summary>
        /// 可消耗天数
        /// </summary>
        public string digestion_days
        {
            get
            {
                try
                {
                    var sales_details_list = sales_details.Replace("[", "").Replace("]", "").Split(',').Select(s => decimal.Parse(s)).ToList();
                    decimal use_stock = 0;
                    if (full_stock <= 0)
                    {
                        return "0";
                    }
                    for (int i = 7, dayIndex = 0; i < sales_details_list.Count; i++, dayIndex++)
                    {
                        dayIndex++;
                        use_stock += sales_details_list[i];
                        if (full_stock <= use_stock)
                        {
                            return dayIndex.ToString();
                        }
                    }
                    return sales_details_list.Count +"+";

                }
                catch (Exception ex)
                {
                    return "";
                }
               
            }
        }

        /// <summary>
        /// 供应链长度总目标销量
        /// </summary>
        public string turnover_days_config_turnover_sales
        {
            get
            {
                try
                {
                    var details = JsonConvert.DeserializeObject<List<decimal>>(sales_day_config_details).Select(s => (int)Math.Ceiling(s)).ToList();
                    return details.Where((s, index) => index <= (turnover_days - 1)).Sum().ToString();
                }
                catch (Exception ex)
                {
                    return "";
                }
               
            }
        }



        /// <summary>
        /// 库存可买日期
        /// </summary>
        public DateTime stock_use_date { get
            {
                return gmt_modified.AddDays(stock_use_days);
            } }

        public int full_stock { get
            {
                return (int)(Math.Ceiling((usable_stock ?? 0) + quantity_transfer + quantity_purchase));
            } }
        /// <summary>
        /// 库存+在途可卖天数
        /// </summary>
        public int full_stock_use_days
        {
            get
            {
                return forecast_average_day <= 0 ? 0 : (int)Math.Ceiling(full_stock / forecast_average_day);
            }
        }
        /// <summary>
        /// 库存+在途可买日期
        /// </summary>
        public DateTime full_stock_use_date
        {
            get
            {
                return gmt_modified.AddDays(full_stock_use_days);
            }
        }



        /// <summary>
        /// Walmart 过去7日销量（日均) 
        /// </summary>
        public decimal history_sevenday_sales_walmart { get; set; }
        /// <summary>
        /// Walmart 过去14日销量（日均)
        /// </summary>
        public decimal history_fourteenday_sales_walmart { get; set; }
        /// <summary>
        /// Walmart 过去30日销量（日均)
        /// </summary>
        public decimal history_thirtyday_sales_walmart { get; set; }
        public string bailun_sku_warehouse_code { get; set; }
        public List<dc_auto_turnover_list_dto> maps { get; set; }

        /// <summary>
        /// 备货数量
        /// </summary>
        public decimal? stock_up_sales { get; set; }

        /// <summary>
        /// 是否监控库容
        /// </summary>
        public int storage_capacity_status { get; set; }
        /// <summary>
        /// 首次出单时间
        /// </summary>
        public DateTime? first_order_date { get; set; }


        /// <summary>
        /// 首次出单的订单
        /// </summary>
        public string first_order_bailun_order_id { get; set; }
        public string product_type_desc { get; set; }
        /// <summary>
        /// 日均出单次数
        /// </summary>
        public decimal? orders_avg { get; set; }
        /// <summary>
        /// 调拨单在途
        /// </summary>
        public int quantity_transfer_order { get; set; }
        public string db_warehouse_name { get; set; }

        /// <summary>
        /// 调拨单采购临时数据
        /// </summary>
        public int quantity_transfer_temp_schedule { get; set; }

        /// <summary>
        /// 调拨在途，暂存
        /// </summary>
        public int quantity_transfer_temporary_storage { get; set; }
        /// <summary>
        /// 待调拨数量
        /// </summary>
        public int not_trans_count { get; set; }
        public string area_name { get; set; }
        public string warehouse_type { get; set; }
        public string head_transport_type { get; set; }
        public string head_transport_logistics_code { get; set; }
        /// <summary>
        /// 销量预测规则
        /// </summary>
        public string dc_auto_sales_forecast_title { get; set; }
        public int quantity_land_purchase { get; set; }
        public DateTime? first_inbound_date { get; set; }
        public int quantity_ocean_purchase { get; set; }
        public int quantity_air_purchase { get; set; }
        public int quantity_railway_purchase { get; set; }
        public int quantity_land_transfer { get; set; }
        public int quantity_ocean_transfer { get; set; }
        public int quantity_air_transfer { get; set; }
        public int quantity_railway_transfer { get; set; }


        public int returngoodspush_state { get; set; }
        public string category_simple_name { get; set; }
        public string brand { get; set; }
        public int id { get; set; }
        public string sales_details { get; set; }
        public int? sku_status { get; set; }
        public string sku_status_str
        {
            get
            {
                if (sku_status == null) return "";
                return ((sku_status_enum)sku_status).ToString();
            }
        }

        /// <summary>
        /// 动态备货规则组
        /// </summary>
        public string group_name { get; set; }
        /// <summary>
        /// 建议单单号
        /// </summary>
        public string purchase_advice_id { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 建议采购数
        /// </summary>
        public int quantity_init_advise { get; set; }

        /// <summary>
        /// 最小订单数量
        /// </summary>
        public int quantity_minimum_order { get; set; }

        /// <summary>
        /// 跟MOQ对比后最终的的自动采购建议
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 活动促销数量
        /// </summary>
        public int quantity_promotion { get; set; }

        /// <summary>
        /// 实际库存数量
        /// </summary>
        public int quantity_inventory { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal quantity_safe_inventory { get; set; }


        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 正常为0, 缺货为1
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 记录时间
        /// </summary>
        public DateTime record_time { get; set; }

        /// <summary>
        /// 与dc_auto_config_promotion的id关联,以逗号分隔
        /// </summary>
        //public string promotions { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }
        public int? supplier_delivery_config { get; set; }

        /// <summary>
        /// 调拨交运时长
        /// </summary>
        public int transfer_delivery { get; set; }
        public string transfer_delivery_source { get; set; }

        /// <summary>
        /// 质检入库时长
        /// </summary>
        public int inspection_delivery { get; set; }
        /// <summary>
        /// 未来7天日均
        /// </summary>

        public int forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 未来14天日均
        /// </summary>
        public int forecast_fourteenday_sales { get; set; }


        /// <summary>
        /// 默认供应商的平均预期天数
        /// </summary>
        public decimal average_overdue { get; set; }

        /// <summary>
        /// 调拨打包天数
        /// </summary>
        public decimal transfer_bale_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public decimal abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 补充销量
        /// </summary>
        public decimal supplementary_sales { get; set; }

        /// <summary>
        /// 本次采购到货到货前
        /// </summary>
        public decimal turnover_sales { get; set; }

        /// <summary>
        /// 周转期内总入库
        /// </summary>
        public decimal turnover_inbound { get; set; }

        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日日均销量
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }


        /// <summary>
        /// 调拨头程天数（用户配置）
        /// </summary>
        public int? transfer_config_delivery { get; set; }
        /// <summary>
        /// 调拨打包天数（用户配置）
        /// </summary>
        public int? transfer_bale_config_delivery { get; set; }
        /// <summary>
        /// 海外仓入库天数（用户配置）
        /// </summary>
        public int? abroad_inbound_config_delivery { get; set; }

        /// <summary>
        /// 初始建议数
        /// </summary>
        public int quantity_begin_advise { get; set; }
        public int original_quantity_init_advise { get; set; }
        public int is_modify_quantity_init_advise { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public int payment_before_delivery { get; set; }

        /// <summary>
        /// 备货天数
        /// </summary>
        public int stock_up_days { get; set; }

        public int stock_up_days_final
        {
            get
            {
                if (stock_up_days >= 1)
                {
                    return stock_up_days - 1;
                }
                else
                {
                    return 0;
                }
            }
        }

        public decimal history_sevenday_sales_ebay { get; set; }
        public decimal history_fourteenday_sales_ebay { get; set; }
        public decimal history_thirtyday_sales_ebay { get; set; }
        public decimal history_sevenday_sales_amazon { get; set; }
        public decimal history_fourteenday_sales_amazon { get; set; }
        public decimal history_thirtyday_sales_amazon { get; set; }

        /// <summary>
        ///昨日销量
        /// </summary>
        public int oneday_sales { get; set; }

        /// <summary>
        /// 预测明日销量
        /// </summary>
        public int forecast_oneday_sales2 { get; set; }

        /// <summary>
        /// 商品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        public string suppliers_name { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 百伦分类
        /// </summary>
        public string bailun_category_name { get; set; }

        /// <summary>
        /// 是否停止监控
        /// </summary>
        public int monitor_status { get; set; }
        public int clearance_status { get; set; }

        public string supplier_name { get; set; }


        public string buyer_name { get; set; }

        /// <summary>
        /// 交期异常
        /// </summary>
        public int? delivery_days_error { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        /// <summary>
        /// 实时库存
        /// </summary>
        public decimal? usable_stock { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal? shipped_stock { get; set; }

        /// <summary>
        /// 供应链链接
        /// </summary>
        public string suppliers_link { get; set; }

        public DateTime? develop_time { get; set; }

        public string has_tort { get; set; }

        /// <summary>
        /// 停止监控的时间
        /// </summary>
        public DateTime? stop_monitor_create { get; set; }

        public decimal history_sevenday_sales_aliexpress { get; set; }
        public decimal history_fourteenday_sales_aliexpress { get; set; }
        public decimal history_thirtyday_sales_aliexpress { get; set; }

        public string sku_label { get; set; }

        /// <summary>
        /// shopify 过去7日销量（日均) 
        /// </summary>
        public decimal history_sevenday_sales_shopify { get; set; }
        /// <summary>
        /// shopify 过去14日销量（日均)
        /// </summary>
        public decimal history_fourteenday_sales_shopify { get; set; }
        /// <summary>
        /// shopify 过去30日销量（日均)
        /// </summary>
        public decimal history_thirtyday_sales_shopify { get; set; }

        /// <summary>
        /// FBA平台asin
        /// </summary>
        public string fba_asin { get; set; }

        /// <summary>
        /// FBA备注销售
        /// </summary>
        public string fba_sale_remark { get; set; }
        /// <summary>
        /// FBA 预计 断货时间（等于可用/加权日均得出的天数 加上当前日期 得出 预计缺货日期）
        /// </summary>
        public DateTime? fba_out_of_stock_predict_time { get; set; }

        /// <summary>
        /// FBA最近即将入库数量（ 调拨在途里面的预计入库时间里面最早的那一单的数量 ）
        /// </summary>
        public int? fba_put_in_qty { get; set; }

        /// <summary>
        /// FBA最近即将入库时间（ 调拨在途里面的预计入库时间里面最早的那一单的时间）
        /// </summary>
        public DateTime? fba_put_in_time { get; set; }

        /// <summary>
        /// FBA是否需要空运（预计断货时间距离最近即将入库时间超过10天）
        /// </summary>
        public bool? fba_need_airlift { get; set; }

        public string fba_need_airlift_str => fba_need_airlift.HasValue && fba_need_airlift.Value == true ? "是" : "否";
    }
}
