﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 子母sku
    /// </summary>
    public class dc_base_mother_sku
    {
        public int id { get; set; }
        public string sku { get; set; }
        public string warehouse_code { get; set; }
        public string sku_warehouse_code { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 库容
        /// </summary>
        public int storage_capacity { get; set; }
    }
    public class dc_base_mother_sku_map
    {
        public int id { get; set; }
        public string mother_sku { get; set; }
        public string mother_warehouse_code { get; set; }
        public string mother_sku_warehouse_code { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        public string bailun_sku_warehouse_code { get; set; }

        /// <summary>
        /// 是否主sku
        /// </summary>
        public int is_main { get; set; }
    }
    public class dc_base_mother_sku_log
    {
        public int id { get; set; }
        public string sku { get; set; }
        public string warehouse_code { get; set; }
        public string sku_warehouse_code { get; set; }
        public string action { get; set; }
        public DateTime create_date { get; set; }
        public string create_user { get; set; }
    }

    public class dc_base_mother_sku_dto: dc_base_mother_sku
    {
        public string warehouse_name { get; set; }
        public List<dc_base_mother_sku_map_dto> maps { get; set; }
    }  public class dc_base_mother_sku_map_dto : dc_base_mother_sku_map
    {
        public string warehouse_name { get; set; }
        public int storage_capacity { get; set; }
    }
    public class dc_base_mother_sku_log_dto : dc_base_mother_sku_log
    {
        public string warehouse_name { get; set; }
    }
    public class dc_base_mother_sku_search_dto
    {
        public string sku { get; set; }
        public string bailun_sku { get; set; }
        [Description("仓库类型")]
        public string warehousetype { get; set; }

        [Description("仓库国家")]
        public int? warehousearea { get; set; }

        [Description("仓库编码")]
        public string warehousecode { get; set; }
    }

    public class dc_base_mother_sku_log_search_dto
    {
        public string sku { get; set; }
      

        [Description("仓库编码")]
        public string warehousecode { get; set; }
    }

    public class update_status_input_dto
    {
        public int id { get; set; }
        public int status { get; set; }
    }

    /// <summary>
    /// 移除子sku
    /// </summary>
    public class remove_map_input_dto
    {
        public List<int> map_ids { get; set; }
    }

    public class batch_set_input_dto
    {
        public List<int> ids { get; set; }
        public int mother_id { get; set; }
        public int is_main { get; set; }
    }
}
