﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
  public  class StockBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromSeconds(60));
            return Task.CompletedTask;

        }
        private void DoWork(object state)
        {
            var now = DateTime.Now;
          
            if (now.Minute == 0)
            {
                if (now.Hour > 2 && now.Hour <= 8)
                {
                    Console.WriteLine($"开始 刷新缺货明细  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    Console.WriteLine("  刷新缺货明细数据 * (数据库忙时，暂停)");
                    Console.WriteLine($"结束 刷新缺货明细  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                else
                {
                    Console.WriteLine($"开始 刷新缺货明细  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.ResetOmsOutofstock();
                    Console.WriteLine($"结束 刷新缺货明细  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
            }

         if (now.Month==1 && now.Day==1 && now.Hour == 0 && now.Minute == 01)
            {
                Console.WriteLine($"开始 刷新年度增长趋势，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.CalculationSalesTrend();
                Console.WriteLine($"结束 刷新年度增长趋势，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 02)
            {
                Console.WriteLine($"开始 备份库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.ResetDailyStockWarehouse();
                Console.WriteLine($"结束 备份库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 10)
            {
                Console.WriteLine($"开始 生成商品报表，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.GenerateReportGoods();
                report.GenerateReportPlatformGoods();
                Console.WriteLine($"结束 生成商品报表，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }

            if (now.Hour == 02 && now.Minute == 1)
            {
                Console.WriteLine($"开始 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_auto_pick_up_goods_order_dao.GenerateOrder(DateTime.Now.AddDays(-1), DateTime.Now);
                Console.WriteLine($"结束 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 02 && now.Minute == 2)
            {
                Console.WriteLine($"开始 拉取lms的渠道数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_base_supplier_dao.SynchroBailunSupplier();
                Console.WriteLine($"结束 拉取lms的渠道数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }

            if (now.DayOfWeek == DayOfWeek.Monday)
            {
                if (now.Hour == 4 && now.Minute == 01)
                {
                    Console.WriteLine($"开始 备份上周库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.StockWeekBackUp();
                    Console.WriteLine($"结束 备份上周库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 4 && now.Minute == 11)
                {
                    Console.WriteLine($"开始 备份上周采购库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.PurchaseWeekBackUp();
                    Console.WriteLine($"结束 备份上周采购库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 4 && now.Minute == 15)
                {
                    Console.WriteLine($"开始 备份上周库存销量报表，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.GenerateWeekTagStockDatas();
                    Console.WriteLine($"结束 备份上周库存销量报表，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
            }

            if (now.Hour==8 && now.Minute == 10)
            {
                Console.WriteLine($"开始 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.ResetFullStock();
                report.ResetStockRecord();
                report.ResetInventory();
                Console.WriteLine($"结束 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 12 && now.Minute == 00)
            {
                Console.WriteLine($"开始 刷新最近7天的oms数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.ResetOms7();
                Console.WriteLine($"结束 刷新最近7天的oms数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }

          
        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
