﻿using AutoTurnOver.Models;
using Bailun.ServiceFabric;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using AutoTurnOver.Utility;
using AutoTurnOver.DB;
using Dapper;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Models.Report;

namespace AutoTurnOver.Services
{
    /// <summary>
    /// 下载服务
    /// </summary>
    public class TaskDownloadServices
    {

        /// <summary>
        /// 开启下载任务
        /// </summary>
        public async Task<int> Download()
        {
            int count = 0;
            var dc_task_download_datas = MyMySqlConnection._connection_read_only.Query<dc_task_download>(" select * from dc_task_download where status=@status order by create_date desc ", new { status = (int)dc_task_download_status.待执行 }).ToList();
            foreach (var item in dc_task_download_datas)
            {
                // 查询当前待处理的任务
                try
                {
                    item.start_date = DateTime.Now;
                    MyMySqlConnection._connection.Update(item);
                    switch (item.task_name)
                    {
                        case "实时库存":
                           item.result_file_url = await DownloadStock(item.parameter, item);
                            break;   
                        case "周转表":
                           item.result_file_url = await DownloadAuto(item.parameter, item);
                            break;    
                        case "销量导入模板":
                           item.result_file_url = await DownloadExportSalesTemplate(item.parameter, item);
                            break; 
                        case "改在线记录":
                           item.result_file_url = await DownloadShortagePush(item.parameter, item);
                            break;
                        case "商品销售情况统计":
                           item.result_file_url = await DownloadGoods(item.parameter, item);
                            break;
                        case "Fba实时库存":
                           item.result_file_url = await DownloadFbaStock(item.parameter, item);
                            break;
                        case "转仓日志":
                           item.result_file_url = await DownloadTransferWarehouseLog(item.parameter, item);
                            break;
                        case "采购建议":
                           item.result_file_url = await DownloadPurchaseAdvise(item.parameter, item);
                            break;
                        case "退货汇总":
                           item.result_file_url = await DownloadReturnGoods(item.parameter, item);
                            break;
                        case "供应链采购在途":
                           item.result_file_url = await DownloadFullLinkPurchase(item.parameter, item);
                            break;
                        case "供应链调拨在途":
                           item.result_file_url = await DownloadFullLinkTransfer(item.parameter, item);
                            break;
                        case "供应链在途订单":
                           item.result_file_url = await DownloadFullLinkWait(item.parameter, item);
                            break;
                        case "商品销量报表（仓库维度）":
                           item.result_file_url = await DownloadReportGoods(item.parameter, item);
                            break;
                        case "商品销量报表（平台维度）":
                           item.result_file_url = await DownloadPlatformReportGoods(item.parameter, item);
                            break;
                        case "利润最大化分析":
                           item.result_file_url = await DownloadProfitAnalysis(item.parameter, item);
                            break;
                        default: throw new Exception("无法识别的任务");
                    }
                    item.end_date = DateTime.Now;
                    item.status = (int)dc_task_download_status.执行完成;
                    count++;
                }
                catch (Exception ex)
                {
                    item.status = (int)dc_task_download_status.执行失败;
                    item.error_message = ex.Message;
                    item.error_stack_trace = ex.StackTrace;
                }
                MyMySqlConnection._connection.Update(item);

            }
            return count;
        }


        /// <summary>
        /// 商品销售情况统计
        /// </summary>
        public async Task<string> DownloadGoods(string par_json, dc_task_download download_data)
        {

            bailun_sku_goods_search_dto search_data = par_json.ToObject<bailun_sku_goods_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var rows = 0;
            var memory = new ReportServices().GetGoodsExport(search_data,out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        
        /// <summary>
        /// 商品销售情况统计
        /// </summary>
        public async Task<string> DownloadReportGoods(string par_json, dc_task_download download_data)
        {

            dc_report_goods_search_dto search_data = par_json.ToObject<dc_report_goods_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            int rows = 0;
            var memory = new ReportServices().ReportGoodsExport(search_data,"","",out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 商品销售情况统计
        /// </summary>
        public async Task<string> DownloadPlatformReportGoods(string par_json, dc_task_download download_data)
        {

            dc_report_goods_platform_search_dto search_data = par_json.ToObject<dc_report_goods_platform_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var rows = 0;
            var memory = new ReportServices().ReportPlatformGoodsExport(search_data,"","",out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 利润最大化分析
        /// </summary>
        public async Task<string> DownloadProfitAnalysis(string par_json, dc_task_download download_data)
        {

            Condition_AutoTurnOver search_data = par_json.ToObject<Condition_AutoTurnOver>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var rows = 0;
            var memory = new SkuAutoTurnServices().ProfitAnalysisExport(search_data,out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }

        /// <summary>
        /// 下载改在线记录
        /// </summary>
        public async Task<string> DownloadShortagePush(string par_json, dc_task_download download_data)
        {

            export_sortage_push_search_dto search_data = par_json.ToObject<export_sortage_push_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            int rows = 0;
            var memory = new DailyServices().ExportShortagePush(search_data,out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载库存
        /// </summary>
        public async Task<string> DownloadStock(string par_json, dc_task_download download_data)
        {
            var rows = 0;
            dc_base_stock_search_dto search_data = par_json.ToObject<dc_base_stock_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new DailyServices().Export(search_data,out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载库存
        /// </summary>
        public async Task<string> DownloadTransferWarehouseLog(string par_json, dc_task_download download_data)
        {

            dc_aims_transfer_warehouse_log_search_dto search_data = par_json.ToObject<dc_aims_transfer_warehouse_log_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new DailyServices().ExportTransferWarehouseLog(search_data);
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载采购建议
        /// </summary>
        public async Task<string> DownloadPurchaseAdvise(string par_json, dc_task_download download_data)
        {

            dc_auto_purchase_advise_detailed_search_dto search_data = par_json.ToObject<dc_auto_purchase_advise_detailed_search_dto>();

            if (search_data.is_delete != 0)
            {
                if(search_data.end_date==null || search_data.start_date==null)
                {
                    throw new Exception("导已过期的数据务必带上时间范围");
                }
                double days = 11;
                try
                {
                    days = (search_data.end_date.Value - search_data.start_date.Value).TotalDays;

                }
                catch (Exception)
                {

                }
                if (days >= 10)
                {
                    throw new Exception("已经过期的数据时间范围不可超过10天");
                }

            }

            Console.WriteLine("DownloadStock - 开始生成文件");
            int rows = 0;
            var memory = new PurchaseAdviseServices().Export(search_data,out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载采购建议
        /// </summary>
        public async Task<string> DownloadReturnGoods(string par_json, dc_task_download download_data)
        {

            dc_aims_return_goods_search_dto search_data = par_json.ToObject<dc_aims_return_goods_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new PurchaseAdviseServices().ExportReturnGoods(search_data);
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载供应链采购在途
        /// </summary>
        public async Task<string> DownloadFullLinkPurchase(string par_json, dc_task_download download_data)
        {

            dc_base_stock_search_dto search_data = par_json.ToObject<dc_base_stock_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new DailyServices().FullLinkPurchaseExport(search_data);
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载供应链调拨在途
        /// </summary>
        public async Task<string> DownloadFullLinkTransfer(string par_json, dc_task_download download_data)
        {

            dc_base_stock_search_dto search_data = par_json.ToObject<dc_base_stock_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new DailyServices().FullLinkTransferExport(search_data);
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载供应链在途
        /// </summary>
        public async Task<string> DownloadFullLinkWait(string par_json, dc_task_download download_data)
        {

            dc_base_full_link_search_dto search_data = par_json.ToObject<dc_base_full_link_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new DailyServices().FullLinkWaitExport(search_data);
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载库存
        /// </summary>
        public async Task<string> DownloadFbaStock(string par_json, dc_task_download download_data)
        {
    
            dc_base_stock_search_dto search_data = par_json.ToObject<dc_base_stock_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            int rows = 0;
            var memory = new DailyServices().FbaExport(search_data,out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载周转表
        /// </summary>
        public async Task<string> DownloadAuto(string par_json, dc_task_download download_data)
        {
            Condition_AutoTurnOver search_data = par_json.ToObject<Condition_AutoTurnOver>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            int rows = 0;
            var memory = new SkuAutoTurnServices().Export(search_data,"","",out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载周转表
        /// </summary>
        public async Task<string> DownloadExportSalesTemplate(string par_json, dc_task_download download_data)
        {
            Condition_AutoTurnOver search_data = par_json.ToObject<Condition_AutoTurnOver>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            int rows = 0;
            var memory = new SkuAutoTurnServices().ExportSalesTemplate(search_data,"","",out rows);
            download_data.rows = rows;
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
    }
}

