﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 利润分析
    /// </summary>
    public class dc_report_profit_analysis
    {
        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public int id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public string bailun_sku { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public string warehouse_code { get; set; }

        /// <summary>
        /// 国家
        /// </summary>
        [Description(@"国家")]
        public string country { get; set; }

        /// <summary>
        /// 仓库类型
        /// </summary>
        [Description(@"仓库类型")]
        public string warehouse_type { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        [Description(@"仓库名称")]
        public string warehouse_name { get; set; }

        /// <summary>
        /// 默认运输方式
        /// </summary>
        [Description(@"默认运输方式")]
        public string transport_type { get; set; }

        /// <summary>
        /// 180 天日均销量
        /// </summary>
        [Description(@"180 天日均销量")]
        public decimal sales_avg_180 { get; set; }

        /// <summary>
        /// 90 天日均销量
        /// </summary>
        [Description(@"90 天日均销量")]
        public decimal sales_avg_90 { get; set; }

        /// <summary>
        /// 30 天日均销量
        /// </summary>
        [Description(@"30 天日均销量")]
        public decimal sales_avg_30 { get; set; }

        /// <summary>
        /// 7天日均销量
        /// </summary>
        [Description(@"7天日均销量")]
        public decimal sales_avg_7 { get; set; }
        /// <summary>
        /// 加权日均销量
        /// </summary>
        public decimal daily_weighted_sales { get; set; }

        /// <summary>
        /// 供应链长度预测销量
        /// </summary>
        public decimal turnover_sales { get; set; }

        /// <summary>
        /// 采购单价
        /// </summary>
        [Description(@"采购单价")]
        public decimal unit_price { get; set; }

        /// <summary>
        /// 实际建议周转数
        /// </summary>
        [Description(@"实际建议周转数")]
        public decimal quantity_final_advise { get; set; }

        /// <summary>
        /// 实际建议周转金额
        /// </summary>
        [Description(@"实际建议周转金额")]
        public decimal quantity_final_advise_amount { get; set; }

        /// <summary>
        /// 实际周转数
        /// </summary>
        [Description(@"实际周转数")]
        public decimal turnover { get; set; }
        /// <summary>
        /// 实际周转金额
        /// </summary>
        [Description(@"实际周转金额")]
        public decimal turnover_amount { get; set; }

        /// <summary>
        /// 实际周转运费
        /// </summary>
        [Description(@"实际周转运费")]
        public decimal freight_price { get; set; }

        /// <summary>
        /// 实际运费单价
        /// </summary>
        [Description(@"实际运费单价")]
        public decimal freight_unit_price { get; set; }

        /// <summary>
        /// 海运周转数
        /// </summary>
        [Description(@"海运周转数")]
        public decimal quantity_final_advise_ocean { get; set; }

        /// <summary>
        /// 海运周转金额
        /// </summary>
        [Description(@"海运周转金额")]
        public decimal quantity_final_advise_ocean_amount { get; set; }

        /// <summary>
        /// 海运周转运费
        /// </summary>
        [Description(@"海运周转运费")]
        public decimal freight_price_ocean { get; set; }

        /// <summary>
        /// 空运周转数
        /// </summary>
        [Description(@"空运周转数")]
        public decimal quantity_final_advise_air { get; set; }

        /// <summary>
        /// 空运周转金额
        /// </summary>
        [Description(@"空运周转金额")]
        public decimal quantity_final_advise_air_amount { get; set; }

        /// <summary>
        /// 空运周转运费
        /// </summary>
        [Description(@"空运周转运费")]
        public decimal freight_price_air { get; set; }

        /// <summary>
        /// 实际海运运费差值
        /// </summary>
        [Description(@"实际海运运费差值")]
        public decimal freight_price_ocean_difference_amount { get; set; }

        /// <summary>
        /// 实际海运周转金额差值
        /// </summary>
        [Description(@"实际海运周转金额差值")]
        public decimal quantity_final_ocean_difference_amount { get; set; }

        /// <summary>
        /// 实际空运运费差值
        /// </summary>
        [Description(@"实际空运运费差值")]
        public decimal freight_price_air_difference_amount { get; set; }

        /// <summary>
        /// 实际空运周转金额差值
        /// </summary>
        [Description(@"实际空运周转金额差值")]
        public decimal quantity_final_air_difference_amount { get; set; }

        /// <summary>
        /// 海运-空运运费差值
        /// </summary>
        [Description(@"海运-空运运费差值")]
        public decimal freight_price_ocean_air_difference { get; set; }

        /// <summary>
        /// 海运-空运周转金额差值
        /// </summary>
        [Description(@"海运-空运周转金额差值")]
        public decimal quantity_final__ocean_air_difference_amount { get; set; }

        /// <summary>
        /// 安全库存数量
        /// </summary>
        [Description(@"安全库存数量")]
        public decimal quantity_safe_inventory { get; set; }

        /// <summary>
        /// 空运周转天数
        /// </summary>
        [Description(@"空运周转天数")]
        public decimal turnover_days_air { get; set; }

        /// <summary>
        /// 实际周转天数
        /// </summary>
        [Description(@"实际周转天数")]
        public decimal turnover_days { get; set; }

        /// <summary>
        /// 海运周转天数
        /// </summary>
        [Description(@"海运周转天数")]
        public decimal turnover_days_ocean { get; set; }

        /// <summary>
        /// 30天预测销量实际-海运金额汇总
        /// </summary>
        [Description(@"30天预测销量实际-海运金额汇总")]
        public decimal freight_price_ocean_30_difference { get; set; }

        /// <summary>
        /// 30天空运-实际
        /// </summary>
        [Description(@"30天空运-实际")]
        public decimal freight_price_air_30_difference { get; set; }

        /// <summary>
        /// 30天空运-海运
        /// </summary>
        [Description(@"30天空运-海运")]
        public decimal freight_price_air_ocean_30_difference { get; set; }

        /// <summary>
        /// 差值(海运)-实际周转金额占比
        /// </summary>
        [Description(@"差值(海运)-实际周转金额占比")]
        public decimal freight_price_ocean_difference_amount_radio { get; set; }

        /// <summary>
        /// 差值(空运)-实际周转金额占比
        /// </summary>
        [Description(@"差值(空运)-实际周转金额占比")]
        public decimal freight_price_air_difference_amount_radio { get; set; }

        /// <summary>
        /// 差值(海运-空运)-实际周转金额占比
        /// </summary>
        [Description(@"差值(海运-空运)-实际周转金额占比")]
        public decimal freight_price_ocean_air_difference_radio { get; set; }

        /// <summary>
        /// 海运-实际运费差额 / 库存金额差值
        /// </summary>
        [Description(@"海运-实际运费差额 / 库存金额差值")]
        public decimal freight_stock_amount_ocean { get; set; }

        /// <summary>
        /// 空运-实际运费差额 / 库存金额差值
        /// </summary>
        [Description(@"空运-实际运费差额 / 库存金额差值")]
        public decimal freight_stock_amount_air { get; set; }

        /// <summary>
        /// 30 天海运-实际运费差额 / 库存金额差值
        /// </summary>
        [Description(@"30 天海运-实际运费差额 / 库存金额差值")]
        public decimal freight_stock_amount_ocean_30 { get; set; }

        /// <summary>
        /// 30 天空运-实际运费差额 / 库存金额差值
        /// </summary>
        [Description(@"30 天空运-实际运费差额 / 库存金额差值")]
        public decimal freight_stock_amount_air_30 { get; set; }

        /// <summary>
        /// 海运建议采购数量
        /// </summary>
        [Description(@"海运建议采购数量")]
        public int ocean_purchase { get; set; }

        /// <summary>
        /// 海运建议采购金额
        /// </summary>
        [Description(@"海运建议采购金额")]
        public decimal ocean_purchase_amount { get; set; }

        public DateTime update_time { get; set;}

        /// <summary>
        /// 计算过程
        /// </summary>
        public string formula_json { get; set;}

        /// <summary>
        /// 预测日均
        /// </summary>
        public decimal forecast_daily_weighted_sales { get; set;}

        public decimal forecast_daily_weighted_sales_ocean { get; set;}
        public decimal forecast_daily_weighted_sales_air { get; set;}
    }

    public  class dc_report_profit_analysis_dto: dc_report_profit_analysis {
        public string product_code { get; set; }
        public decimal? weight { get; set; }
        public string product_name { get; set; }

    }
}
