﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.Report
{
    /// <summary>
    /// 出纳流水
    /// </summary>
    public  class dc_base_finance_cashier
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 出纳编号
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 申请单编号
        /// </summary>
        public string apply_id { get; set; }

        /// <summary>
        /// 申请标题
        /// </summary>
        public string detail_name { get; set; }

        /// <summary>
        /// 出纳单类型:1#付款;2#收款;3#无需付款;
        /// </summary>
        public int cashier_type { get; set; }

        /// <summary>
        /// 费用大类
        /// </summary>
        public string type_name { get; set; }

        /// <summary>
        /// 公司主体值
        /// </summary>
        public int companymain_value_from { get; set; }

        /// <summary>
        /// 公司主体名称
        /// </summary>
        public string companymain_name_from { get; set; }

        /// <summary>
        /// 交易币种编号
        /// </summary>
        public string unit_code { get; set; }

        /// <summary>
        /// 交易币种名称
        /// </summary>
        public string unit_name { get; set; }

        /// <summary>
        /// 交易总金额
        /// </summary>
        public decimal paymoney { get; set; }

        /// <summary>
        /// 交易总金额-人民币
        /// </summary>
        public decimal paymoney_rmb { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int payday { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public DateTime? expect_paytime { get; set; }

        /// <summary>
        /// 交易对象类型:1#供应商;2#费用用户;
        /// </summary>
        public int tradeb_bjecttype { get; set; }

        /// <summary>
        /// 交易对象id
        /// </summary>
        public int tradeb_bjectid { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string tradeb_bjectname { get; set; }

        /// <summary>
        /// 交易-银行账户ID
        /// </summary>
        public int bankaccountid_to { get; set; }

        /// <summary>
        /// 交易-银行账号
        /// </summary>
        public string bankcard_to { get; set; }

        /// <summary>
        /// 交易-银行名称
        /// </summary>
        public string bankname_to { get; set; }

        /// <summary>
        /// 交易持卡人
        /// </summary>
        public string bankcarduser_to { get; set; }

        /// <summary>
        /// 申请备注
        /// </summary>
        public string applyremark { get; set; }

        /// <summary>
        /// 出纳回调状态:0#未回调;1#回调成功;2#回调失败;
        /// </summary>
        public int cashier_callbackstatus { get; set; }

        /// <summary>
        /// 申请来源编号
        /// </summary>
        public string sourcecode { get; set; }

        /// <summary>
        /// 申请来源名称
        /// </summary>
        public string sourcename { get; set; }

        /// <summary>
        /// 出纳状态:0#待收付;1#已收付;2#已驳回;3#无需付款;4#申请代付未付款;5#1688自动付款失败;
        /// </summary>
        public int cashier_status { get; set; }

        /// <summary>
        /// 付款方式:0#手工付款;1#1688自动付款;
        /// </summary>
        public int pay_type { get; set; }

        /// <summary>
        ///  出纳操作人
        /// </summary>
        public int cashier_userid { get; set; }

        /// <summary>
        /// 出纳操作人名称
        /// </summary>
        public string cashier_username { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public DateTime? cashier_time { get; set; }

        /// <summary>
        /// 出纳操作备注
        /// </summary>
        public string cashier_remark { get; set; }

        /// <summary>
        /// 出纳账户id
        /// </summary>
        public int cashier_bankaccountid { get; set; }

        /// <summary>
        /// 出纳账户名称
        /// </summary>
        public string cashier_bankname { get; set; }

        /// <summary>
        /// 出纳账户卡号
        /// </summary>
        public string cashier_bankcard { get; set; }

        /// <summary>
        /// 出纳账户持卡人
        /// </summary>
        public string cashier_bankcardname { get; set; }

        /// <summary>
        /// 出纳币种编号
        /// </summary>
        public string cashier_unitcode { get; set; }

        /// <summary>
        /// 出纳币种名称
        /// </summary>
        public string cashier_unitname { get; set; }

        /// <summary>
        /// 出纳汇率
        /// </summary>
        public decimal cashier_rate { get; set; }

        /// <summary>
        /// 出纳总金额
        /// </summary>
        public decimal cashier_paymoney { get; set; }

        /// <summary>
        /// 出纳人民币总金额
        /// </summary>
        public decimal cashier_paymoneyrmb { get; set; }

        /// <summary>
        /// 是否有问题:0#正常;1#问题单
        /// </summary>
        public int isquestion { get; set; }

        /// <summary>
        /// 问题单备注
        /// </summary>
        public string question_remark { get; set; }

        /// <summary>
        /// 1688/淘宝订单号
        /// </summary>
        public string taobao_order_no { get; set; }

        /// <summary>
        /// 其他订单流水号
        /// </summary>
        public string otherorder_code { get; set; }

        /// <summary>
        ///  创建人id
        /// </summary>
        public int create_userid { get; set; }

        /// <summary>
        /// 创建人名称
        /// </summary>
        public string create_username { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public DateTime? create_time { get; set; }

        /// <summary>
        /// 更新人id
        /// </summary>
        public int modify_userid { get; set; }

        /// <summary>
        /// 更新人名称
        /// </summary>
        public string modify_username { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime? modify_time { get; set; }
    }


    /// <summary>
    /// 供应商主体
    /// </summary>
    public class dc_base_finance_cashier_body_dto
    {
        public  string tradeb_bjectname { get; set; }
    }
}
