﻿using AutoTurnOver.Models;
using Dapper;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using AutoTurnOver.Utility;

namespace AutoTurnOver.DB
{
    /// <summary>
    /// 全量改零监控
    /// </summary>
    public class dc_config_full_push_monitor_dao : connectionHelper
    {
        public static List<dc_config_full_push_monitor> StorageCapacityList(dc_base_storage_capacity_search_dto m, int offset, int limit, ref int total)
        {
            var list = new List<dc_config_full_push_monitor>();
            DynamicParameters parameters = new DynamicParameters();
            try
            {
                var sql = @"select t1.*,t2.`warehouse_name` as 'warehouse_name' from dc_config_full_push_monitor as t1
left join dc_base_warehouse as t2 on t1.warehouse_code = t2.warehouse_code where 1 = 1 ";

                if (!string.IsNullOrWhiteSpace(m.warehousetype))
                {
                    sql += " and t2.hq_type=@hq_type";
                    parameters.Add("hq_type", m.warehousetype);
                }
                if (m.warehousearea > 0)
                {
                    sql += " and t2.area_id=@warehousearea ";
                    parameters.Add("warehousearea", m.warehousearea);
                }

                if (!string.IsNullOrWhiteSpace(m.bailun_sku))
                {
                    sql += " and t1.bailun_sku = @bailun_sku ";
                    parameters.Add("bailun_sku", m.bailun_sku);
                }

                if (!string.IsNullOrWhiteSpace(m.warehousecode))
                {
                    sql += " and t1.warehouse_code=@warehousecode ";
                    parameters.Add("warehousecode", m.warehousecode);
                }
               

                total = _connection.QuerySingleOrDefault<int>("select count(0) from (" + sql + ") tb1", parameters);

                var obj = _connection.Query<dc_config_full_push_monitor>(sql + " limit " + offset + "," + limit, parameters);

                return obj.AsList();

            }
            catch (Exception ex)
            {
                return list;
            }
        }


        public static List<dc_config_full_push_monitor_log> StorageCapacityLogList(dc_base_storage_capacity_log_search_dto m, int offset, int limit, ref int total)
        {
            var list = new List<dc_config_full_push_monitor_log>();
            DynamicParameters parameters = new DynamicParameters();
            try
            {
                var sql = @"select t1.*,t2.`warehouse_name` as 'warehouse_name' from dc_config_full_push_monitor_log as t1
left join dc_base_warehouse as t2 on t1.warehouse_code = t2.warehouse_code where 1 = 1 ";

                if (!string.IsNullOrWhiteSpace(m.warehousetype))
                {
                    sql += " and t2.hq_type=@hq_type";
                    parameters.Add("hq_type", m.warehousetype);
                }
                if (m.warehousearea > 0)
                {
                    sql += " and t2.area_id=@warehousearea ";
                    parameters.Add("warehousearea", m.warehousearea);
                }

                if (!string.IsNullOrWhiteSpace(m.bailun_sku))
                {
                    sql += " and t1.bailun_sku = @bailun_sku ";
                    parameters.Add("bailun_sku", m.bailun_sku);
                }

                if (!string.IsNullOrWhiteSpace(m.warehousecode))
                {
                    sql += " and t1.warehouse_code=@warehousecode ";
                    parameters.Add("warehousecode", m.warehousecode);
                }
                if (m.btime != null)
                {
                    sql += " and t1.date>=@btime ";
                    parameters.Add("btime", m.btime.Value.ToDayHome());
                }
                if (m.etime != null)
                {
                    sql += " and t1.date<=@etime ";
                    parameters.Add("etime", m.etime.Value.ToDayHome());
                }

                total = _connection.QuerySingleOrDefault<int>("select count(0) from (" + sql + ") tb1", parameters);

                sql += " order by t1.date desc ";
                var obj = _connection.Query<dc_config_full_push_monitor_log>(sql + " limit " + offset + "," + limit, parameters);

                return obj.AsList();

            }
            catch (Exception)
            {
                return list;
            }
        }

        /// <summary>
        /// 新增日志
        /// </summary>
        /// <param name="data"></param>
        /// <param name="is_share">是否需要处理共享仓</param>
        public static void AddLog(dc_config_full_push_monitor_log data,int is_share = 0)
        {
            if (string.IsNullOrWhiteSpace(data.create_user))
            {
                throw new Exception("创建人必填");
            }
           
            data.unique_no = $"{data.bailun_sku}{data.warehouse_code}{data.platform_type}";
            var conn = MyMySqlConnection._connection;
            conn.Open();
            using (var t = conn.BeginTransaction())
            {
                try
                {
                    // 查询是否有库容记录
                    var mainData = conn.QuerySingleOrDefault<dc_config_full_push_monitor>(" select * from dc_config_full_push_monitor where unique_no=@unique_no ", new
                    {
                        unique_no = data.unique_no
                    });
                    if (mainData == null)
                    {
                        mainData = new dc_config_full_push_monitor
                        {
                            unique_no = data.unique_no,
                            warehouse_code = data.warehouse_code,
                            platform_type = data.platform_type,
                            bailun_sku = data.bailun_sku
                           
                        };
                        mainData.id = conn.Insert(mainData) ?? 0;
                    }

                    data.date = DateTime.Now;
                    conn.Insert(data);
                    int line_count = conn.Execute(" update dc_config_full_push_monitor set status=@status where unique_no=@unique_no ", new
                    {
                        status = mainData.status,
                        unique_no = mainData.unique_no
                    });
                    if (line_count <= 0)
                    {
                        AddLog(data);
                    }

                    t.Commit();
                }
                catch (Exception ex)
                {
                    t.Rollback();
                    throw;
                }

            }
        }

    }
}
