﻿using AutoTurnOver.Models.Base;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.Report
{
    /// <summary>
    /// 现金流预测任务
    /// </summary>
    public class dc_report_cash_flow_forecast_task
    {
        public int id { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_type { get; set; }
        public string platform_type { get; set; }
        public string web_site { get; set; }
        /// <summary>
        /// 采购供应商交期
        /// </summary>
        public int delivery { get; set; }
        /// <summary>
        /// 调拨交期
        /// </summary>
        public int transfer_days { get; set; }
        /// <summary>
        /// 运输方式 -1 = 无 1 = 陆运 2 = 海运 3 = 空运
        /// </summary>
        public int transport_type { get; set; }
        /// <summary>
        /// 付款方式 1先款后货，2先货后款，3无需付款
        /// </summary>
        public int buy_pay_type { get; set; }
        /// <summary>
        /// 采购付款账期
        /// </summary>
        public int buy_pay_days { get; set; }
        /// <summary>
        /// 头程物流
        /// </summary>
        public string transfer_logistics_code { get; set; }
        public string transfer_logistics_name { get; set; }
        /// <summary>
        /// 尾程物流
        /// </summary>
        public string tail_logistics_code { get; set; }
        public string tail_logistics_name { get; set; }
        /// <summary>
        /// 退款率
        /// </summary>
        public decimal refund_ratio { get; set; }
        /// <summary>
        /// 采购单价
        /// </summary>
        public decimal buy_unit_price_cny { get; set; }
        /// <summary>
        /// 采购moq
        /// </summary>
        public int moq { get; set; }
        /// <summary>
        /// 销售单价
        /// </summary>
        public decimal sale_unit_price_cny { get; set; }
        /// <summary>
        /// 状态 0 = 已提交 1=计算中 2= 计算完成  3 = 计算异常
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 计算步骤
        /// </summary>
        public string step { get; set; }
        public string error_message { get; set; }
        public string error_stack_trace { get; set; }
        public decimal high { get; set; }
        public decimal @long { get; set; }
        public decimal weight_kg { get; set; }
        public decimal width { get; set; }
        public DateTime update_time { get; set; }

        /// <summary>
        /// 尾程费单价
        /// </summary>
        public decimal? tail_logistics_fee { get; set; }
        /// <summary>
        /// 头程费单价
        /// </summary>
        public decimal? transfer_logistics_fee { get; set; }
        /// <summary>
        /// 平台费单价
        /// </summary>
        public decimal?  platform_fee { get; set; }
        public int platform_category_id { get; set; }

        /// <summary>
        /// paypal费率
        /// </summary>
        public decimal? paypal_fee { get; set; }

        /// <summary>
        /// fba费率
        /// </summary>
        public decimal? fba_fee { get; set; }

        /// <summary>
        /// 广告费率
        /// </summary>
        public decimal? ad_fee { get; set; }

        /// <summary>
        /// 刊登费
        /// </summary>
        public decimal? pps_fee { get; set; }


    }

    public class dc_report_cash_flow_forecast_task_info_dto
    {
        public List<report_cash_flow_view_dto> views { get; set; }
        public List<turnover_dto> turnovers { get; set; }

        public class turnover_dto
        {
            public string item_title { get; set; }
            public List<int> types { get; set; }

            public List<date_dto> dates { get; set; }
            public class date_dto
            {
                public string date_title { get; set; }

                public DateTime btime { get; set; }
                public DateTime etime { get; set; }
                public decimal val { get; set; }
            }
        }
    }

    public class report_cash_flow_view_forecast_task_search_dto
    {
        public int task_id { get; set; }
        
    }

    public class dc_report_cash_flow_log_export_forecast_task_search_dto: page_search_dto
    {
        public DateTime? btime { get; set; }
        public bool issum { get; set; }
        public DateTime? etime { get; set; }
        public List<int> data_type { get; set; }
        /// <summary>
        /// 1 = 根据发生时间查询
        /// 2 = 根据支付时间查询
        /// </summary>
        public int? type { get; set; }
        public int? task_id { get; set; }
        public int? view_type { get; set; }
    }

    public class dc_report_cash_flow_forecast_task_dto: dc_report_cash_flow_forecast_task
    {
        
        public string warehouse_name { get; set; }

        public string status_str { get
            {
                return ((dc_report_cash_flow_forecast_task_status)status).ToString();
            } }
    }

    public class dc_report_cash_flow_forecast_task_date_dto
    {
        public string btime { get; set; }
        public string etime { get; set; }
    }

    public class dc_report_cash_flow_forecast_task_input_dto: dc_report_cash_flow_forecast_task_dto
    {
        public string btime { get; set; }
        public string etime { get; set; }
        public List<sale_dto> sales { get; set; }

        public class sale_dto
        {
            public DateTime date { get; set; }
            public decimal val { get; set; }
        }
    }

    public enum dc_report_cash_flow_forecast_task_status
    {
        已提交=0,
        计算中=1,
       计算完成=2,
       计算异常=3
    }

    public class dc_report_cash_flow_forecast_task_search_dto
    {
        public string bailun_sku { get; set; }
    }

    public class dc_report_cash_flow_forecast_task_sale
    {
        public int id { get; set; }
        public int task_id { get; set; }
        public DateTime date { get; set; }
        /// <summary>
        /// 销量
        /// </summary>
        public decimal val { get; set; }
    }

    public class dc_report_cash_flow_forecast_task_log
    {
        public int id { get; set; }

        public int task_id { get; set; }
        public string warehouse_code { get; set; }
        public string platform_type { get; set; }
        public string bailun_sku { get; set; }
        /// <summary>
        /// 1 = 销售数量 2 = 售金额 3 = 退款  4 = 利润  5 =平台费用  6=释放销售成本  7 = 释放头程费用  8 = 尾程费用  9 = 新增采购费用 10 =  新增头程费用
        /// </summary>
        public int data_type { get; set; }
        /// <summary>
        /// 1 = 实时  2 = 后付 3 = 后收 4 =预付
        /// </summary>
        public int pay_type { get; set; }
        /// <summary>
        /// 发送数值
        /// </summary>
        public decimal val { get; set; }
        /// <summary>
        /// 发送时间
        /// </summary>
        public DateTime occur_time { get; set; }
        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime pay_time { get; set; }
        /// <summary>
        /// 相关单号
        /// </summary>
        public string no { get; set; }
        /// <summary>
        /// 项目
        /// </summary>
        public string item { get; set; }
        /// <summary>
        /// 项目编号
        /// </summary>
        public string item_no { get; set; }
        public string web_site { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remarks { get; set; }

        /// <summary>
        /// 是否作废
        /// </summary>
        public int is_delete { get; set; }
        public DateTime update_time { get; set; }
        public string pay_time_year_month_no { get; set; }
        public string occur_time_year_month_no { get; set; }
    }

    public class dc_report_cash_flow_forecast_turnover
    {
        public int id { get; set; }
        public DateTime date { get; set; }
        /// <summary>
        /// 预测数值
        /// </summary>
        public decimal val { get; set; }

        public int type { get; set; }
    }

    /// <summary>
    /// 虚拟周转模型，用来虚拟下单
    /// </summary>
    public class invented_turnover_model
    {
        public int id { get; set; }
        public int task_id { get; set; }
        public DateTime date { get; set; }
        public string date_str { get { return date.ToString("yyyy-MM-dd"); } }

        /// <summary>
        /// 预测数值
        /// </summary>
        public decimal val { get; set; }

        /// <summary>
        /// 1 = 预测可用库存
        /// 2 =  预测采购数量 未考虑 moq 备货天数
        /// 3 = 考虑备货天数 跟 moq 之后的采购数量
        /// </summary>
        public int type { get; set; }

        public enum type_enum
        {
            入库数量 = 1,
            采购数量 = 2,
            最终采购数量 = 3,
            销量 = 4,
            可用库存 = 5,
            /// <summary>
            /// 采购中转仓入库之后，下调拨单
            /// </summary>
            调拨下单 = 6
        }
    }

}
