﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Cors;
using System.Net;
using AutoTurnOver.Common;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CommonController : BaseController
    {
        /// <summary>
        /// 获取仓库列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult ListWareHouse(string type,int? areaId)
        {
            
            
            var list = new CommonServices().ListWareHouse(type, areaId);
            return new JsonResult(list);
        }

        /// <summary>
        /// 获取仓库类型列表
        /// </summary>
        /// <returns></returns>
        public JsonResult ListWareHouseType()
        {
            var list = new CommonServices().ListWareHouseType();
            return new JsonResult(list);
        }

        /// <summary>
        /// 获取仓库类型列表
        /// </summary>
        /// <returns></returns>
        public JsonResult GetUser()
        {
            var user = AutoUtility.GetUser();
            return new JsonResult(new { data = user });
        }

        

        /// <summary>
        /// 获取仓库国家列表
        /// </summary>
        /// <returns></returns>
        public JsonResult ListWareHouseArea()
        {
            var list = new CommonServices().ListWareHouseArea();
            return new JsonResult(list);
        }


        public JsonResult GetCategoryList()
        {
            var datas = ApiServices.GetCategoryList();
            return new JsonResult(datas);
        }

        /// <summary>
        /// 获取一二级的百伦数据
        /// </summary>
        /// <returns></returns>
        public JsonResult GetCategoryAll()
        {
            try
            {
                var datas = ApiServices.GetCategoryAll().Select(s=> new {
                    id = s.C_ID,
                    pId = s.C_PARENTID,
                    name = s.C_CNAME,
                    open = false
                });
                return new JsonResult(new
                {
                    data = datas,
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false
                });
            }
            
        }
        

    }
}