﻿using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace AutoGeneratePurchaseAdvise
{
    public class GeneratePurchaseAdviseBackgroundService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;
        }

        private void DoWork(object state)  
        {
            try
            {
                var now = DateTime.Now;
                // 判断是不是指定的时间
                if (now.Hour == 5 && now.Minute == 1)
                {
                    Console.WriteLine($"开始采购平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.Generate();
                    Console.WriteLine($"结束采购平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
