﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ShortagePush
{
    public class ShortagePushBackgroundService : BackgroundService
    {


        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        System.Console.WriteLine($"开始推送改零数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        new ReportServices().ShortagePush();
                        System.Console.WriteLine($"结束推送改零数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        System.Console.WriteLine($"开始推送回货数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        new ReportServices().ReturnGoodsPush();
                        System.Console.WriteLine($"结束推送回货数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }
                    

                    Thread.Sleep(30 * 60 * 1000);
                }
            });
            
            Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        System.Console.WriteLine($"开始推送 Ebay 改零数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        new ReportServices().ShortagePushEbay();
                        System.Console.WriteLine($"结束推送 Ebay 改零数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        System.Console.WriteLine($"开始推送 Ebay 回货数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        new ReportServices().ReturnGoodsPushEaby();
                        System.Console.WriteLine($"结束推送 Ebay 回货数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }
                    

                    Thread.Sleep(10 * 60 * 1000);
                }
            });


            return Task.CompletedTask;

        }

        

        public override void Dispose()
        {
            base.Dispose();
        }
    }
}
