﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
  public  class CaseFlowBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;

        }
        private void DoWork(object state)
        {
            var now = DateTime.Now;
           
            if (now.Hour == 0 && now.Minute == 01)
            {
                Console.WriteLine($"开始 刷新现金流  订单数据 （销售），线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationOrder(now.AddMonths(-3),DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  订单数据（销售），线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 02)
            {
                Console.WriteLine($"开始 刷新现金流  采购数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationPurchaseOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  采购数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 03)
            {
                Console.WriteLine($"开始 刷新现金流  调拨数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationTransferOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  调拨数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 04)
            {
                Console.WriteLine($"开始 刷新现金流  退款数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationRefundOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  退款数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            } 
            if (now.Hour == 0 && now.Minute == 05)
            {
                Console.WriteLine($"开始 刷新订单尾程费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationOrderCostLogistics(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束 刷新订单尾程费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 2 && now.Minute == 23)
            {
                if (now.DayOfWeek == DayOfWeek.Monday)
                {
                    Console.WriteLine($"开始 刷新上周数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.ResetLastweekData();
                    Console.WriteLine($"结束 刷新上周数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
            }
            if (now.Hour == 0 && now.Minute == 24)
            {
                Console.WriteLine($"开始 刷新ebay 广告费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationAdFeeEbay(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束 刷新ebay 广告费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 25)
            {
                Console.WriteLine($"开始 刷新amazon 广告费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationAdFeeAmazon(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束 刷新amazon 广告费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 26)
            {
                Console.WriteLine($"开始 刷新ebay 上架费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationPublishFeeEbay(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束 刷新ebay 上架费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 4 && now.Minute == 01)
            {
                Console.WriteLine($"开始刷新 现金流 sku 报表 数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.ResetCashFlowData();
                Console.WriteLine($"结束刷新 现金流 sku 报表 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
           

        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
