﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ReturnGoodsController : ControllerBase
    {
        [HttpGet]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【自动下单管理】->【退货汇总】->【搜索】页面", 0)]
        public JsonResult SkuPage([FromQuery]dc_auto_return_goods_sku_search_dto search)
        {

            var total = 0;
            var service = new Services.ReturnGoodsConfigServices();
            var list = service.SkuPage(search, search.offset ?? 0, search.limit ?? 0, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }
        
        [HttpGet]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【下单需取货汇总】->【搜索】页面", 0)]
        public JsonResult PickSkuPage([FromQuery]dc_auto_return_goods_sku_search_dto search)
        {

            var total = 0;
            var service = new Services.ReturnGoodsConfigServices();
            var list = service.PickSkuPage(search, search.offset ?? 0, search.limit ?? 0, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }
        
        [HttpGet]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【自动下单管理】->【退货汇总】->【推送】操作", 0)]
        public JsonResult Push([FromQuery]dc_auto_return_goods_sku_search_dto search)
        {
            try
            {
                var service = new Services.ReturnGoodsConfigServices();
                service.Push(search, AutoUtility.GetUser());

                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success  = false,message = ex.Message});
            }
            
        }

       

        /// <summary>
        /// 批量修改
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [BrowseLog("Bailun_aims", "触发【百伦自动周转系统】->【自动下单管理】->【退款汇总】->【批量审批】操作", 3)]
        public JsonResult BatchApproval([FromBody]batch_approval_input_dto input_data )
        {
            try
            {
                var user = AutoUtility.GetUser();
                if (user == null) return null;
                new Services.ReturnGoodsConfigServices().BatchApproval(input_data, user);
                return new JsonResult("");
            }
            catch (Exception ex)
            {
                return new JsonResult(ex.Message);
            }
        }
    }
}