﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
  public  class ResetOutofstockBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 刷新现金流  订单数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        var now = DateTime.Now;
                        report_cash_flow_dao.CalculationOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                        Console.WriteLine($"结束 刷新现金流  订单数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });
          

            Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        wip_stock_dao.Synchronization();
                        Console.WriteLine($"结束 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });

             Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新缺货明细数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report.ResetOutofstock();
                        Console.WriteLine($"结束刷新缺货明细数据任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        if (DateTime.Now.Hour >= 8)
                        {
                            Console.WriteLine($"开始刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            report.ResetStockMonitorData();
                            Console.WriteLine($"结束刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }

                    Thread.Sleep(5 * 60 * 1000);
                }
            });
            
            Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 listing 数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report.ResetDataHighFrequency();
                        Console.WriteLine($"结束刷新 listing 数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }

                    Thread.Sleep(30 * 60 * 1000);
                }
            });

            
            return Task.CompletedTask;
        }

        
        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
