﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AutoTurnOver.Models;
using AutoTurnOver.Models.Report;
using Dapper;

namespace AutoTurnOver.DB
{
    /// <summary>
    /// 现金流计算
    /// </summary>
    public class report_cash_flow_dao : connectionHelper
    {
        /// <summary>
        /// 计算订单
        /// </summary>
        public static void CalculationOrder(DateTime btime, DateTime? etime)
        {
            try
            {
                var conn = _connection;
                int page = 1;
                int rows = 1000;
                List<dc_report_cash_flow_config> configs = conn.Query<dc_report_cash_flow_config>(" select * from dc_report_cash_flow_config ").AsList();
                while (true)
                {
                    var sql = " select * from dc_base_oms_sku where gmt_create>=@btime ";
                    DynamicParameters parameters = new DynamicParameters();
                    parameters.Add("btime", btime.ToString("yyyy-MM-dd 00:00:00"));
                    if (etime != null)
                    {
                        sql += " and gmt_create<=@etime ";
                        parameters.Add("etime", etime.Value.ToString("yyyy-MM-dd 23:59:59"));
                    }
                    sql += $" limit {(page - 1) * rows},{rows} ";
                    var order_list = conn.Query<dc_base_oms_sku>(sql, parameters).AsList();
                    if (order_list == null || order_list.Count <= 0)
                    {
                        break;
                    }
                    page++;
                    foreach (var order_item in order_list)
                    {
                        try
                        {
                            #region 释放头程费用

                            dc_report_cash_flow_log item6 = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.释放头程费用,
                                is_delete = (order_item.has_delete == 1 || order_item.has_scalp == 1) ? 1 : 0,
                                item = order_item.bailun_order_id,
                                no = order_item.bailun_order_id,
                                platform_type = order_item.platform_type,
                                remarks = "",
                                val = order_item.cost_first * order_item.bailun_sku_quantity_ordered,
                                occur_time = order_item.paid_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.后收,
                                item_no = order_item.bailun_order_id
                            };
                            item6.pay_time = CalculationPayTime(configs, item6.occur_time, item6.data_type, item6.platform_type);
                            item6.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item6.data_type,
                                bailun_sku = item6.bailun_sku,
                                item_no = item6.item_no
                            }) ?? 0;
                            if (item6.id > 0)
                            {
                                conn.Update(item6);
                            }
                            else
                            {
                                conn.Insert(item6);
                            }

                            #endregion

                            #region 销售释放成本

                            dc_report_cash_flow_log item5 = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.释放销售成本,
                                is_delete = (order_item.has_delete == 1 || order_item.has_scalp == 1) ? 1 : 0,
                                item = order_item.bailun_order_id,
                                no = order_item.bailun_order_id,
                                platform_type = order_item.platform_type,
                                remarks = "",
                                val = order_item.cost_product * order_item.bailun_sku_quantity_ordered,
                                occur_time = order_item.paid_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.后收,
                                item_no = order_item.bailun_order_id
                            };
                            item5.pay_time = CalculationPayTime(configs, item5.occur_time, item5.data_type, item5.platform_type);
                            item5.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item5.data_type,
                                bailun_sku = item5.bailun_sku,
                                item_no = item5.item_no
                            }) ?? 0;
                            if (item5.id > 0)
                            {
                                conn.Update(item5);
                            }
                            else
                            {
                                conn.Insert(item5);
                            }

                            #endregion

                            #region 尾程费

                            dc_report_cash_flow_log item4 = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.平台费用,
                                is_delete = (order_item.has_delete == 1 || order_item.has_scalp == 1) ? 1 : 0,
                                item = order_item.bailun_order_id,
                                no = order_item.bailun_order_id,
                                platform_type = order_item.platform_type,
                                remarks = "",
                                val = order_item.cost_logistics * order_item.bailun_sku_quantity_ordered,
                                occur_time = order_item.paid_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.后付,
                                item_no = order_item.bailun_order_id
                            };
                            item4.pay_time = CalculationPayTime(configs, item4.occur_time, item4.data_type, item4.platform_type);
                            item4.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item4.data_type,
                                bailun_sku = item4.bailun_sku,
                                item_no = item4.item_no
                            }) ?? 0;
                            if (item4.id > 0)
                            {
                                conn.Update(item4);
                            }
                            else
                            {
                                conn.Insert(item4);
                            }

                            #endregion

                            #region 平台费

                            dc_report_cash_flow_log item3 = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.平台费用,
                                is_delete = (order_item.has_delete == 1 || order_item.has_scalp == 1) ? 1 : 0,
                                item = order_item.bailun_order_id,
                                no = order_item.bailun_order_id,
                                platform_type = order_item.platform_type,
                                remarks = "",
                                val = order_item.cost_platform_fee * order_item.seller_order_exchange_rate * order_item.bailun_sku_quantity_ordered,
                                occur_time = order_item.paid_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.后付,
                                item_no = order_item.bailun_order_id
                            };
                            item3.pay_time = CalculationPayTime(configs, item3.occur_time, item3.data_type, item3.platform_type);
                            item3.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item3.data_type,
                                bailun_sku = item3.bailun_sku,
                                item_no = item3.item_no
                            }) ?? 0;
                            if (item3.id > 0)
                            {
                                conn.Update(item3);
                            }
                            else
                            {
                                conn.Insert(item3);
                            }

                            #endregion

                            #region 利润

                            dc_report_cash_flow_log item2 = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.利润,
                                is_delete = (order_item.has_delete == 1 || order_item.has_scalp == 1) ? 1 : 0,
                                item = order_item.bailun_order_id,
                                no = order_item.bailun_order_id,
                                platform_type = order_item.platform_type,
                                remarks = "",
                                val = order_item.profit_total * order_item.bailun_sku_quantity_ordered,
                                occur_time = order_item.paid_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.实时,
                                item_no = order_item.bailun_order_id
                            };
                            item2.pay_time = CalculationPayTime(configs, item2.occur_time, item2.data_type, item2.platform_type);
                            item2.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item2.data_type,
                                bailun_sku = item2.bailun_sku,
                                item_no = item2.item_no
                            }) ?? 0;
                            if (item2.id > 0)
                            {
                                conn.Update(item2);
                            }
                            else
                            {
                                conn.Insert(item2);
                            }

                            #endregion

                            #region 销售数量

                            dc_report_cash_flow_log item1 = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.销售数量,
                                is_delete = (order_item.has_delete == 1 || order_item.has_scalp == 1) ? 1 : 0,
                                item = order_item.bailun_order_id,
                                no = order_item.bailun_order_id,
                                platform_type = order_item.platform_type,
                                remarks = "",
                                val = order_item.bailun_sku_quantity_ordered,
                                occur_time = order_item.paid_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.实时,
                                item_no = order_item.bailun_order_id
                            };
                            item1.pay_time = CalculationPayTime(configs, item1.occur_time, item1.data_type, item1.platform_type);
                            item1.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item1.data_type,
                                bailun_sku = item1.bailun_sku,
                                item_no = item1.item_no
                            }) ?? 0;
                            if (item1.id > 0)
                            {
                                conn.Update(item1);
                            }
                            else
                            {
                                conn.Insert(item1);
                            }

                            #endregion

                            #region 销售金额

                            dc_report_cash_flow_log item = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.销售金额,
                                is_delete = (order_item.has_delete == 1 || order_item.has_scalp == 1) ? 1 : 0,
                                item = order_item.bailun_order_id,
                                no = order_item.bailun_order_id,
                                platform_type = order_item.platform_type,
                                remarks = "",
                                val = order_item.amount_sales * order_item.seller_order_exchange_rate * order_item.bailun_sku_quantity_ordered,
                                occur_time = order_item.paid_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.实时,
                                item_no = order_item.bailun_order_id
                            };
                            item.pay_time = CalculationPayTime(configs, item.occur_time, item.data_type, item.platform_type);
                            item.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item.data_type,
                                bailun_sku = item.bailun_sku,
                                item_no = item.item_no
                            }) ?? 0;
                            if (item.id > 0)
                            {
                                conn.Update(item);
                            }
                            else
                            {
                                conn.Insert(item);
                            }

                            #endregion
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine($"现金流-订单-{order_item.bailun_order_id}-异常" + ex.Message);
                            Console.WriteLine("现金流-订单-异常" + ex.StackTrace);
                        }

                        


                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("现金流-订单-异常"+ex.Message);
                Console.WriteLine("现金流-订单-异常" + ex.StackTrace);
            }
           

        }

        /// <summary>
        /// 计算采购订单
        /// </summary>
        /// <param name="btime"></param>
        /// <param name="etime"></param>
        public static void CalculationPurchaseOrder(DateTime btime, DateTime etime)
        {
            try
            {
                var conn = _connection;
                int page = 1;
                int rows = 1000;
                List<dc_report_cash_flow_config> configs = conn.Query<dc_report_cash_flow_config>(" select * from dc_report_cash_flow_config ").AsList();
                while (true)
                {
                    var sql = " select t1.*,t2.pay_time from dc_base_purchase_details as t1 left join dc_base_purchase as t2 on t1.purchase_id = t2.purchase_id and t1.bailun_sku = t2.bailun_sku where t1.gmt_create>=@btime and t1.gmt_create<=@etime ";
                    DynamicParameters parameters = new DynamicParameters();
                    parameters.Add("btime", btime.ToString("yyyy-MM-dd 00:00:00"));
                    parameters.Add("etime", etime.ToString("yyyy-MM-dd 23:59:59"));
                    sql += $" limit {(page - 1) * rows},{rows} ";
                    var order_list = conn.Query<dc_base_purchase_details_dto>(sql, parameters).AsList();
                    if (order_list == null || order_list.Count <= 0)
                    {
                        break;
                    }
                    page++;
                    foreach (var order_item in order_list)
                    {
                        try
                        {
                            #region 采购支出

                            dc_report_cash_flow_log item = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.新增采购费用,
                                is_delete = (order_item.status == -1) ? 1 : 0,
                                item = order_item.purchase_id,
                                no = order_item.purchase_id,
                                platform_type = "",
                                remarks = "",
                                val = 0 - Math.Abs(order_item.amount_paid),
                                occur_time = order_item.create_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = order_item.warehouse_from_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.后付,
                                item_no = order_item.purchase_id
                            };
                            if (order_item.pay_type == 3) // 无需付款
                            {
                                item.pay_time = order_item.create_time ?? new DateTime(1991, 1, 1);
                            }
                            else
                            {
                                item.pay_time = order_item.pay_time ?? new DateTime(1991, 1, 1);
                            }
                            item.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item.data_type,
                                bailun_sku = item.bailun_sku,
                                item_no = item.item_no
                            }) ?? 0;
                            if (item.id > 0)
                            {
                                conn.Update(item);
                            }
                            else
                            {
                                conn.Insert(item);
                            }

                            #endregion
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine($"现金流-采购单-{order_item.purchase_id}-异常" + ex.Message);
                            Console.WriteLine("现金流-采购单-异常" + ex.StackTrace);
                        }
                        
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("现金流-采购单-异常" + ex.Message);
                Console.WriteLine("现金流-采购单-异常" + ex.StackTrace);
            }
            
        }

        /// <summary>
        /// 计算退款数据
        /// </summary>
        /// <param name="btime"></param>
        /// <param name="etime"></param>
        public static void CalculationRefundOrder(DateTime btime, DateTime etime)
        {
            try
            {
                var conn = _connection;
                int page = 1;
                int rows = 1000;
                List<dc_report_cash_flow_config> configs = conn.Query<dc_report_cash_flow_config>(" select * from dc_report_cash_flow_config ").AsList();
                while (true)
                {
                    var sql = " select t1.* from dc_base_crm_refund as t1 where gmt_create>=@btime and gmt_create<=@etime ";
                    DynamicParameters parameters = new DynamicParameters();
                    parameters.Add("btime", btime.ToString("yyyy-MM-dd 00:00:00"));
                    parameters.Add("etime", etime.ToString("yyyy-MM-dd 23:59:59"));
                    sql += $" limit {(page - 1) * rows},{rows} ";
                    var order_list = conn.Query<dc_base_crm_refund>(sql, parameters).AsList();
                    if (order_list == null || order_list.Count <= 0)
                    {
                        break;
                    }
                    page++;
                    foreach (var order_item in order_list)
                    {
                        try
                        {
                            #region 退款费用

                            dc_report_cash_flow_log item = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.退款,
                                is_delete = (order_item.is_deleted == 1) ? 1 : 0,
                                item = order_item.origin_order_id,
                                no = order_item.origin_order_id,
                                platform_type = "",
                                remarks = "",
                                val = 0 - Math.Abs(order_item.amount_refund_rmb),
                                occur_time = order_item.refund_time ?? new DateTime(1991, 1, 1),
                                warehouse_code = "",
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.实时,
                                item_no = order_item.crm_id.ToString()
                            };

                            item.pay_time = order_item.refund_time ?? new DateTime(1991, 1, 1);

                            item.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item.data_type,
                                bailun_sku = item.bailun_sku,
                                item_no = item.item_no
                            }) ?? 0;
                            if (item.id > 0)
                            {
                                conn.Update(item);
                            }
                            else
                            {
                                conn.Insert(item);
                            }

                            #endregion
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine($"现金流-退款-{order_item.origin_order_id}-异常" + ex.Message);
                            Console.WriteLine($"现金流-退款-异常" + ex.StackTrace);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("现金流-退款-异常" + ex.Message);
                Console.WriteLine("现金流-退款-异常" + ex.StackTrace);
            }
            
        }

        /// <summary>
        /// 计算调拨订单
        /// </summary>
        /// <param name="btime"></param>
        /// <param name="etime"></param>
        public static void CalculationTransferOrder(DateTime btime, DateTime etime)
        {
            try
            {
                var conn = _connection;
                int page = 1;
                int rows = 1000;
                List<dc_report_cash_flow_config> configs = conn.Query<dc_report_cash_flow_config>(" select * from dc_report_cash_flow_config ").AsList();
                while (true)
                {
                    var sql = @" select t1.*,t2.create_time as 'complete_time',ifnull(t3.cost_first,0) as 'cost_first' from 
dc_base_transfer_verify as t1 
left join dc_base_transfer_complete as t2 on t1.bailun_sku = t2.bailun_sku and t1.transfer_order_id = t2.transfer_order_id
left join dc_mid_cost_first_order as t3 on t1.bailun_sku = t3.bailun_sku and t1.transfer_order_id = t3.transfer_order_id
where t1.create_time>=@btime and t1.create_time<=@etime ";
                    DynamicParameters parameters = new DynamicParameters();
                    parameters.Add("btime", btime.ToString("yyyy-MM-dd 00:00:00"));
                    parameters.Add("etime", etime.ToString("yyyy-MM-dd 23:59:59"));
                    sql += $" limit {(page - 1) * rows},{rows} ";
                    var order_list = conn.Query<dc_base_transfer_verify_dto>(sql, parameters).AsList();
                    if (order_list == null || order_list.Count <= 0)
                    {
                        break;
                    }
                    page++;
                    foreach (var order_item in order_list)
                    {
                        try
                        {
                            #region 调拨支出

                            dc_report_cash_flow_log item = new dc_report_cash_flow_log()
                            {
                                bailun_sku = order_item.bailun_sku,
                                data_type = (int)dc_report_cash_flow_log_data_type_enum.新增头程费用,
                                is_delete = (order_item.deleted == 1) ? 1 : 0,
                                item = order_item.transfer_order_id,
                                no = order_item.transfer_order_id,
                                platform_type = "",
                                remarks = "",
                                val = 0 - Math.Abs(order_item.cost_first),
                                occur_time = order_item.create_time,
                                warehouse_code = order_item.warehouse_code,
                                pay_type = (int)dc_report_cash_flow_log_pay_type_enum.后付,
                                item_no = order_item.transfer_order_id
                            };
                            item.pay_time = order_item.complete_time ?? new DateTime(1991, 1, 1);
                            item.id = conn.QuerySingleOrDefault<int?>(" select * from dc_report_cash_flow_log where data_type=@data_type and  bailun_sku=@bailun_sku and item_no=@item_no ", new
                            {
                                data_type = item.data_type,
                                bailun_sku = item.bailun_sku,
                                item_no = item.item_no
                            }) ?? 0;
                            if (item.id > 0)
                            {
                                conn.Update(item);
                            }
                            else
                            {
                                conn.Insert(item);
                            }

                            #endregion
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine($"现金流-调拨单-{order_item.transfer_order_id}-异常" + ex.Message);
                            Console.WriteLine("现金流-调拨单-异常" + ex.StackTrace);
                        }
                        
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("现金流-调拨单-异常" + ex.Message);
                Console.WriteLine("现金流-调拨单-异常" + ex.StackTrace);
            }
            
        }

        /// <summary>
        /// 计算支付时间
        /// </summary>
        public static DateTime CalculationPayTime(List<dc_report_cash_flow_config> configs, DateTime occur_time, int data_type, string platform_type)
        {
            var item_config = configs.FirstOrDefault(s => s.data_type == data_type && (s.platform_type == "" || s.platform_type.Equals(platform_type)));
            if (item_config == null)
            {
                return occur_time;
            }
            else
            {
                if (item_config.settlement_type == (int)dc_report_cash_flow_settlement_type_enum.等长顺延)
                {
                    return occur_time.AddDays(item_config.settlement_val);
                }
                else if (item_config.settlement_type == (int)dc_report_cash_flow_settlement_type_enum.月度固定)
                {
                    if (occur_time.Day < item_config.settlement_val)
                    {
                        return DateTime.Parse(occur_time.ToString($"yyyy-MM-{item_config.settlement_val} HH:mm:ss"));
                    }
                    else
                    {
                        return DateTime.Parse(occur_time.AddMonths(1).ToString($"yyyy-MM-{item_config.settlement_val} HH:mm:ss"));
                    }
                }
                else
                {
                    return occur_time;
                }
            }
        }
    }
}
