﻿using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Services
{
    public class ConfigServices
    {
        #region 安全库存规则配置

        /// <summary>
        /// 获取安全库存规则设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_safe_inventoryDto> InventoryList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.InventoryList(m, offset, limit, ref total);
        }


        /// <summary>
        /// 保存安全库存规则
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveInventory(Models.dc_auto_config_safe_inventory m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }
            m.warehouse_name = objWarehouse.warehouse_name;

            if (m.type == (int)Safe_inventoryType.仓库_SKU_定值)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "Sku不能为空！";
                }
                if (m.param <= 0)
                {
                    return "安全库存必填";
                }
            }
            else if (m.type == (int)Safe_inventoryType.仓库_分类_定值)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "请选择分类";
                }
                if (m.param <= 0)
                {
                    return "安全库存必填";
                }
                var cID = 0;
                if (!int.TryParse(m.variable_code, out cID))
                {
                    return "请选择分类";
                }
                var cModel = ApiServices.GetCategoryById(cID);
                m.variable_name = cModel.C_CNAME;
            }
            else if (m.type == (int)Safe_inventoryType.仓库_SKU_按历史计算 || m.type == (int)Safe_inventoryType.仓库_SKU_按预测计算 || m.type == (int)Safe_inventoryType.仓库_按历史计算)
            {
                if (m.weighting_coefficient_seven <= 0)
                {
                    return "请填写7天权重";
                }
                if (m.weighting_coefficient_fourteen <= 0)
                {
                    return "请填写14天权重";
                }
                if (m.weighting_coefficient_thirty <= 0)
                {
                    return "请填写30天权重";
                }
                if (m.weighting_coefficient_thirty + m.weighting_coefficient_seven + m.weighting_coefficient_fourteen != 1)
                {
                    return "三个权重加起来不等于 1";
                }
            }

            if (m.type == (int)Safe_inventoryType.仓库_按历史计算)
            {
                if (m.param <= 0)
                {
                    return "倍数必填";
                }
                m.variable_code = "";
                m.variable_name = "";
            }


            if (m.type == (int)Safe_inventoryType.仓库_SKU_定值 || m.type == (int)Safe_inventoryType.仓库_SKU_按历史计算 || m.type == (int)Safe_inventoryType.仓库_SKU_按预测计算)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "Sku不能为空！";
                }
                var objProduct = DB.common.GetPrductBySku(m.variable_code);
                if (objProduct == null)
                {
                    return "系统找不到该Sku。";
                }
                m.variable_name = objProduct.sku_title_cn;
            }


            return DB.db_config.SaveInventory(m, username);
        }



        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_safe_inventory GetInventoryById(int id)
        {
            return DB.db_config.GetInventoryById(id);
        }

        #endregion

        #region 销量上限规则配置

        /// <summary>
        /// 获取安全库存规则设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_sales_upper_limitDto> SalesUpperLimitList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.SalesUpperLimitList(m, offset, limit, ref total);
        }


        /// <summary>
        /// 保存安全库存规则
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveSalesUpperLimit(Models.dc_auto_config_sales_upper_limit m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }
            m.warehouse_name = objWarehouse.warehouse_name;

            if (m.type == (int)Safe_UpperLimitType.仓库_SKU_定值)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "Sku不能为空！";
                }
                if (m.param <= 0)
                {
                    return "安全库存必填";
                }
            }
            else if (m.type == (int)Safe_UpperLimitType.仓库_分类_定值)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "请选择分类";
                }
                if (m.param <= 0)
                {
                    return "安全库存必填";
                }
                var cID = 0;
                if (!int.TryParse(m.variable_code, out cID))
                {
                    return "请选择分类";
                }
                var cModel = ApiServices.GetCategoryById(cID);
                m.variable_name = cModel.C_CNAME;
            }
            else if (m.type == (int)Safe_UpperLimitType.仓库_SKU_按历史计算)
            {
                if (m.param <= 0)
                {
                    return "倍数必填";
                }
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "Sku不能为空！";
                }
                if (m.weighting_coefficient_seven <= 0)
                {
                    return "请填写7天权重";
                }
                if (m.weighting_coefficient_fourteen <= 0)
                {
                    return "请填写14天权重";
                }
                if (m.weighting_coefficient_thirty <= 0)
                {
                    return "请填写30天权重";
                }
                if (m.weighting_coefficient_thirty + m.weighting_coefficient_seven + m.weighting_coefficient_fourteen != 1)
                {
                    return "三个权重加起来不等于 1";
                }
            }




            if (m.type == 1 || m.type == 11 || m.type == 12)
            {
                var objProduct = DB.common.GetPrductBySku(m.variable_code);
                if (objProduct == null)
                {
                    return "系统找不到该Sku。";
                }
                m.variable_name = objProduct.sku_title_cn;
            }


            return DB.db_config.SaveSalesUpperLimit(m, username);
        }



        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_sales_upper_limit GetSalesUpperLimitById(int id)
        {
            return DB.db_config.GetSalesUpperLimitById(id);
        }

        #endregion

        #region 供应链长度规则配置

        /// <summary>
        /// 获取供应链长度规则设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_delivery_dto> ConfigDeliveryList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.ConfigDeliveryList(m, offset, limit, ref total);
        }


        /// <summary>
        /// 保存安全库存规则
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveConfigDelivery(Models.dc_auto_config_delivery m, string username)
        {

            if (m.tranfer_bale <= 0)
            {
                return "调拨打包天数必填！";
            }
            if (m.tranfer_head <= 0)
            {
                return "调拨头程天数必填！";
            }
            if (m.abroad_inbound <= 0)
            {
                return "海外仓入库天数必填！";
            }

            if (m.type == (int)dc_auto_config_delivery_dto.type_enum.仓库)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "仓库不能为空！";
                }

                var objWarehouse = DB.common.GetWareHouseByCode(m.variable_code);
                if (objWarehouse == null)
                {
                    return "系统找不到该仓库。";
                }
                m.variable_name = objWarehouse.warehouse_name;
            }
           
            else if (m.type == (int)dc_auto_config_delivery_dto.type_enum.仓库编码_SKU)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "Sku不能为空！";
                }
                var objProduct = DB.common.GetPrductBySku(m.variable_code);
                if (objProduct == null)
                {
                    return "系统找不到该Sku。";
                }
                m.variable_name = objProduct.sku_title_cn;
            }


            return DB.db_config.SaveConfigDelivery(m, username);
        }



        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_delivery GetConfigDeliveryById(int id)
        {
            return DB.db_config.GetConfigDeliveryById(id);
        }

        #endregion

        #region 备货天数配置

        /// <summary>
        /// 获取备货天数设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_stock_up_days> StockUpList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.StockUpList(m, offset, limit, ref total);
        }


        /// <summary>
        /// 保存备货天数
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveStockUp(Models.dc_auto_config_stock_up_days m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }
            m.warehouse_name = objWarehouse.warehouse_name;

            if (m.stock_up_days < 1)
            {
                return "备货天数不可小于1";
            }

            return DB.db_config.SaveStockUp(m, username);
        }



        /// <summary>
        /// 获取备货天数设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_stock_up_days GetStockUpById(int id)
        {
            return DB.db_config.GetStockUpById(id);
        }

        #endregion

        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string MonitorStatus(string bailun_sku, string warehouse_code, int monitor_status, UserData user)
        {
            return DB.db_config.MonitorStatus(bailun_sku, warehouse_code, monitor_status, user);
        }

        public string BatchMonitorStatus(string ids, int monitor_status, UserData user)
        {
            return DB.db_config.BatchMonitorStatus(ids, monitor_status, user);
        }


        #region fba共享仓发货仓配置

        /// <summary>
        /// fba共享仓发货仓配置
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_base_stock_config_fba> StockFbaList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.StockFbaList(m, offset, limit, ref total);
        }

        public List<dc_base_stock_config_fba_lose> StockFbaLoseList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.StockFbaLoseList(m, offset, limit, ref total);
        }

        /// <summary>
        /// 保存备货天数
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveStockFba(Models.dc_base_stock_config_fba m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            if (string.IsNullOrWhiteSpace(m.platform_sku))
            {
                return "请填写平台sku！";
            }

            // 查询百伦sku

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }
            m.warehouse_name = objWarehouse.warehouse_name;


            return DB.db_config.SaveStockFba(m, username);
        }



        /// <summary>
        /// 获取备货天数设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_base_stock_config_fba GetStockFbaById(int id)
        {
            return DB.db_config.GetStockFbaById(id);
        }

        #endregion
    }
}
