﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Serialization;
using AutoTurnOver.Models;
using Newtonsoft.Json;
using Microsoft.AspNetCore.Cors;
using AutoTurnOver.Utility;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SkuAutoTurnController : BaseController
    {

        /// <summary>
        /// 获取sku周转列表
        /// </summary>
        /// <param name="page">当前分页</param>
        /// <param name="pagesize">每页记录数</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult List(int limit, int offset, string order,string sort,string sku,int? IsRedundant,int? IsStockOut,string warehousecode)
        {

            var m = new Condition_AutoTurnOver {
                bailun_sku = sku,
                out_of_stock = IsStockOut,
                redundancy = IsRedundant,
                warehouse_code = warehousecode,
                
            };

            var total = 0;
            var service = new Services.SkuAutoTurnServices();
            var list = service.List(m, offset, limit, ref total,order,sort).Select(p=>new {
                p.bailun_sku,
                p.sku_title,
                p.warehouse_code,
                p.warehouse_name,
                p.quantity_minimum_order,
                p.quantity_final_advise,
                p.quantity_promotion,
                p.quantity_inventory,
                p.turnover_days,
                p.quantity_safe_inventory,
                p.inspection_delivery,
                p.status,
                p.id,
                p.quantity_out_stock,
                p.supplier_delivery,
                p.transfer_delivery,
                p.quantity_purchase,
                p.quantity_transfer,
                p.forecast_fourteenday_sales,
                p.forecast_sevenday_sales,
                p.oneday_sales,
                p.forecast_oneday_sales2

            });

            return new JsonResult(new
            {
                rows = list,
                total = total,
                pagecount = (total / limit + (total % limit > 0 ? 1 : 0))
            });
        }

        #region 特殊销售设置

        /// <summary>
        /// 获取特殊销售设置列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult ListSaleSetting(int limit, int offset, string order, string sort, string sku, string warehousecode,bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective
            };

            var total = 0;
            var service = new Services.SkuAutoTurnServices();
            var list = service.List(m,offset,limit,ref total).Select(p=>new {
                p.bailun_sku,
                p.warehouse_code,
                p.warehouse_name,
                promotion_time = p.promotion_time.ToString("yyyy-MM-dd"),
                p.count,
                p.remark,
                p.bl_auditor,
                p.status,
                p.id
            });

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存特殊销售设置
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult SaveSaleSetting(int id, string sku, string warehousecode, DateTime time, int count, string note, string username)
        {
            var m = new Models.dc_auto_config_promotion {
                id = id,
                bailun_sku = sku,
                count = count,
                bl_operator = username,
                bl_auditor = "",
                gmt_create = DateTime.Now,
                gmt_modified = DateTime.Now,
                promotion_time = time,
                remark = note,
                status = 0,
                warehouse_code = warehousecode,
                warehouse_name = "",
            };

            var result = new Services.SkuAutoTurnServices().SaveSaleSetting(m, username);
            return new JsonResult(result);
        }

        [HttpPost]
        public JsonResult AddsSaleSetting([FromForm]string datasStr)
        {
            var datasObj = datasStr.ToObj<List<dc_auto_config_promotion_input>>();
            try
            {
                new Services.SkuAutoTurnServices().AddsSaleSetting(datasObj);
                return new JsonResult(new
                {
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new {
                    success = false,
                    message = ex.Message
                });
            }
            
        }

        /// <summary>
        /// 获取特殊销售设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetSaleSettingById(int id)
        {
            var m = new Services.SkuAutoTurnServices().GetSaleSettingById(id);
            
            return new JsonResult(new {
                m.id,
                m.bailun_sku,
                m.bl_auditor,
                m.bl_operator,
                m.count,
                vtime = m.promotion_time.ToString("yyyy-MM-dd"),
                m.remark,
                m.status,
                m.warehouse_code,
                m.warehouse_name
            });
        }

        #endregion

        #region 预计断货Sku

        public JsonResult ListOutStock(string sku,string warehousecode,int offset,int limit)
        {
            var m = new Condition_AutoTurnOver {
                bailun_sku = sku,
                warehouse_code = warehousecode,
                out_of_stock = 1,
            };

            var total = 0;
            var service = new Services.SkuAutoTurnServices();
            var list = service.List(m, offset, limit, ref total,"", "short_supply_time").Select(p=>new {
                gmt_modified = p.gmt_modified.ToString("yyyy-MM-dd HH:mm:ss"),
                p.bailun_sku,
                p.warehouse_name,
                short_supply_time = "",
                short_supply_days = 0,
                p.id,
                p.warehouse_code
            });

            return new JsonResult(new
            {
                rows = list,
                total = total
            });
        }

        #endregion

        #region 市场因素配置

        /// <summary>
        /// 获取市场因素设置列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult ListCorrection(int limit, int offset, string order, string sort, string sku, string warehousecode, bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective
            };

            var total = 0;
            var service = new Services.SkuAutoTurnServices();
            var list = service.CorrectionList(m, offset, limit, ref total).Select(p => new {
                p.bailun_sku,
                p.warehouse_code,
                p.warehouse_name,
                start_time = p.start_time.ToString("yyyy-MM-dd"),
                end_time = p.end_time.ToString("yyyy-MM-dd"),
                p.param,
                p.remark,
                p.id
            });

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存市场因素设置
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult SaveCorrection(int id, string sku, string warehousecode, DateTime btime,DateTime etime, decimal param, string note, string username)
        {
            var m = new Models.dc_auto_config_correction
            {
                id = id,
                bailun_sku = sku,
                param = param,
                bl_operator = username,
                gmt_create = DateTime.Now,
                gmt_modified = DateTime.Now,
                start_time = btime,
                end_time = etime,
                remark = note,
                warehouse_code = warehousecode,
                warehouse_name = "",
            };

            var result = new Services.SkuAutoTurnServices().SaveCorrection(m, username);
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取市场因素设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetCorrectionById(int id)
        {
            var m = new Services.SkuAutoTurnServices().GetCorrectionById(id);

            return new JsonResult(new
            {
                m.id,
                m.bailun_sku,
                m.bl_operator,
                m.param,
                bvtime = m.start_time.ToString("yyyy-MM-dd"),
                evtime = m.end_time.ToString("yyyy-MM-dd"),
                m.remark,
                m.warehouse_code,
                m.warehouse_name
            });
        }

        #endregion

    }
}