﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ReportsController : ControllerBase
    {
        /// <summary>ForecastSalePutinStockShort
        /// 获取预测销售+入库+库存+缺货数
        /// </summary>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <returns></returns>
        public JsonResult ForecastSalePutinStockShort(string sku, string warehousecode)
        {
            var services = new Services.ReportServices();
            var result = services.ForecastSalePutinStockShort(sku, warehousecode);

            var count = 0;
            foreach (var item in result)
            {
                var arr = item.Split(',');

                if (arr.Length > 1)
                {
                    count = arr.Length;
                    break;
                }
            }
            //[0.13, 0.12, 0.11, 0.11, 0.1, 0.09, 0.09, 0.08, 0.08, 0.07, 0.06, 0.06, 0.05, 0.04, 0.04, 0.03, 0.02, 0.02, 0.01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
            var date = new List<string>();
            var today = DateTime.Now.AddDays(-7);

            for (var i = 0; i < count; i++)
            {
                date.Add(today.AddDays(i).ToString("MM/dd"));
            }

            var names = new List<string>() { "销量", "预计入库", "可用库存", "预计缺货数量", "特殊销量","市场因素" };
            var turnoverData = new Services.SkuAutoTurnServices().GetModel(sku, warehousecode);
            var saleVolumeData = new Services.SaleVolumeServices().GetBySkuWarehouseCode(sku, warehousecode);
            var averageTargets = PurchaseAverageTargetServices.GetList(sku);
            var averageTargetWarehouse = PurchaseAverageTargetServices.GetWarehouse(sku, warehousecode);
            return new JsonResult(new { data = result, turnoverData, saleVolumeData, days = date, names, averageTargets, averageTargetWarehouse });
        }

    }
}