﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Services;
using AutoTurnOver.Models;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderController : ControllerBase
    {
        #region 下单管理

        /// <summary>
        /// 下单记录分页
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult List(string sku,string warehousecode,int offset,int limit,string order,string sort)
        {
            var m = new Condition_AutoOrder {
                sku = sku,
                warehousecode = warehousecode,
            };

            var services = new AutoOrderServices();
            var total = 0;
            var list = services.List(m, offset, limit, ref total).Select(p=> new {
                createtime = p.createtime.ToString("yyyy-MM-dd HH:mm:ss"),
                p.bailun_sku,
                p.warehouse_name,
                type = Enum.GetName(typeof(EnumAutoOrderType),p.type),
                p.buycount,
                p.suppliername,
                arrivaltime = p.arrivaltime.ToString("yyyy-MM-dd"),
            });

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        #endregion

        #region 销量管理

        /// <summary>
        /// 获取Sku销量详情
        /// </summary>
        /// <param name="id">主键id</param>
        /// <returns></returns>
        public JsonResult GetSaleVolume(int id)
        {
            var services = new Services.SaleVolumeServices();
            var result = services.GetByTurnOverId(id);

            var _service = new Services.SkuAutoTurnServices();
            var inventory = new dc_auto_inventory();

            if (result != null && result.bailun_sku!=null && result.warehouse_code!=null)
            {
                inventory = _service.GetAutoInventoryBySkuWH(result.bailun_sku, result.warehouse_code);
            }
            
            return new JsonResult(new {
                volume = result,
                inventory = inventory
            });
        }

        #endregion

    }
}