﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DailyController : Controller
    {

        ///
        [HttpGet]
        public JsonResult PurchaseList(string warehousecode, string sku)
        {
           
            var service = new Services.DailyServices();
            var list = service.List(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        /// <summary>
        /// 实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult RealtimeList(string sku, string warehousecode, string product_inner_code, string sku_title_cn, int offset, int limit, string order, string sort)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.RealtimeList(sku, warehousecode,product_inner_code, sku_title_cn, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public FileResult ExportRealtime(string sku, string warehousecode, string product_inner_code, string sku_title_cn)
        {
            var services = new DailyServices();
            var total = 0;
            var list = services.RealtimeList(sku, warehousecode, product_inner_code, sku_title_cn, 0, int.MaxValue, ref total);

            DataTable table = new DataTable();
            string[] cols = new string[] { "Sku", "仓库编码", "仓库名称", "可用库存", "占用库存", "预分配库存", "在途库存" };
            foreach (var item in cols)
            {
                table.Columns.Add(item);
            }

            foreach (var itemData in list)
            {
                DataRow row = table.NewRow();

                row["Sku"] = itemData.bailun_sku;
                row["仓库编码"] = itemData.warehouse_code;
                row["仓库名称"] = itemData.warehouse_name;
                row["可用库存"] = itemData.quantity_avaliable;
                row["占用库存"] = itemData.quantity_occupied;
                row["预分配库存"] = itemData.quantity_virtual;
                row["在途库存"] = itemData.purchase_daily_quantity;

                table.Rows.Add(row);
            }

            var fileName = AppContext.BaseDirectory+ @"Result\RealtimeStock\实时库存.csv";
           
            DataTableHelper.SaveCSV(table, fileName);

            var memory = new MemoryStream();
            using (var stream = new FileStream(fileName, FileMode.Open))
            {
                stream.CopyTo(memory);
            }
            memory.Position = 0;
            return File(memory, "text/csv", "实时库存.csv");
        }
    }
}