﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ConfigController : Controller
    {
        #region 安全库存规则

        /// <summary>
        /// 获取安全库存规则设置列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult InventoryList(int limit, int offset, string order, string sort, string sku, string warehousecode, bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.InventoryList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存安全库存规则设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SaveInventory([FromBody]dc_auto_config_safe_inventory m)
        {
            var result = new Services.ConfigServices().SaveInventory(m,"");
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetInventoryById(int id)
        {
            var m = new Services.ConfigServices().GetInventoryById(id);

            return new JsonResult(m);
        }

        #endregion

        #region 销量上限规则

        /// <summary>
        /// 获取销量上限设置列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult SalesUpperLimitList(int limit, int offset, string order, string sort, string sku, string warehousecode, bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.SalesUpperLimitList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存销量上限设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SaveSalesUpperLimit([FromBody]dc_auto_config_sales_upper_limit m)
        {
            var result = new Services.ConfigServices().SaveSalesUpperLimit(m, "");
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取销量上限设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetSalesUpperLimitById(int id)
        {
            var m = new Services.ConfigServices().GetSalesUpperLimitById(id);

            return new JsonResult(m);
        }

        #endregion
    }
}