﻿using System;
using System.Collections.Generic;
using System.Text;
using AutoTurnOver.Models;
using AutoTurnOver.DB;

namespace AutoTurnOver.Services
{
    public class SaleVolumeServices
    {
        /// <summary>
        /// 获取sku的销量信息
        /// </summary>
        /// <param name="id">自动周转id</param>
        /// <returns></returns>
        public dc_auto_sales GetByTurnOverId(int id)
        {
            return DB.SaleVolume.GetByTurnOverId(id);
        }


        /// <summary>
        /// 获取sku预测销量详情信息
        /// </summary>
        /// <param name="id">主键id</param>
        /// <returns></returns>
        public dc_auto_sales GetById(int id)
        {
            return DB.SaleVolume.GetById(id);
        }

        /// <summary>
        /// 获取sku预测销量详情信息
        /// </summary>
        /// <param name="id">主键id</param>
        /// <returns></returns>
        public dc_auto_sales GetBySkuWarehouseCode(string sku, string warehousecode)
        {
            return DB.SaleVolume.GetBySkuWarehouseCode(sku, warehousecode);
        }

    }
}
