﻿using System;
using System.Collections.Generic;
using System.Text;
using AutoTurnOver.Models;
using AutoTurnOver.DB;
using System.Linq;
using AutoTurnOver.Utility;

namespace AutoTurnOver.Services
{
    public class ReportServices
    {
        /// <summary>
        /// 获取预测销售+入库+库存+缺货数
        /// </summary>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <returns></returns>
        public List<string> ForecastSalePutinStockShort(string sku, string warehousecode)
        {
            var list = new List<string>();

            //获取预测销量
            //var sales = DB.SaleVolume.GetBySkuWarehouseCode(sku, warehousecode);

            var sales = DB.dc_auto_turnover.GetModel(sku, warehousecode);

            //获取预计采购入库
            //var buyputin = DB.dc_auto_turnover.GetAutoInboundBySkuWH(sku, warehousecode,1);

            //获取预计调拨入库
            //var allotputin = DB.dc_auto_turnover.GetAutoInboundBySkuWH(sku, warehousecode, 2);

            // 预计入库
            var putin = DB.dc_auto_turnover.GetAutoInboundBySkuWH(sku, warehousecode, 0);

            //可用库存
            var inventory = DB.dc_auto_turnover.GetAutoInventoryBySkuWH(sku, warehousecode);

            //缺货数量
            var shortsupply = DB.dc_auto_turnover.GetAutoShortSupplyBySkuWH(sku, warehousecode);


            list.Add(sales != null ? sales.sales_details : "[]");
            //list.Add(buyputin != null ? buyputin.details : "[]");
            //list.Add(allotputin != null ? allotputin.details : "[]");
            list.Add(putin != null ? putin.details : "[]");
            list.Add(inventory != null ? inventory.details : "[]");
            list.Add(shortsupply != null ? shortsupply.details : "[]");

            // 计算涉及的总天数
            int count = list.Max(s => s.Split(',').Length);

            DateTime today = DateTime.Now.AddDays(-7);
            DateTime endDay = today.AddDays(count);
            // 查询这些时间范围的 特殊销量情况
            var configPromotionList = DB.dc_auto_turnover.ListConfigPromotion(sku, warehousecode, today, endDay);

            // 查询这些时间范围的 市场因素情况
            var correctionList = DB.dc_auto_turnover.ListCorrection(sku, warehousecode, today, endDay);

            // 用于存储特殊销量规则
            List<int> tempStrList = new List<int>();

            // 用于存储市场因素规则
            List<decimal> tempCorrectionStrList = new List<decimal>();
            for (var i = 0; i < count; i++)
            {
                var tempDate = today.AddDays(i);
                var tempDateHome = DateTime.Parse(tempDate.ToString("yyyy-MM-dd 00:00:00"));
                var tempDateEnd = DateTime.Parse(tempDate.ToString("yyyy-MM-dd 23:59:59"));
                var tempData = configPromotionList.FirstOrDefault(s => s.promotion_time >= tempDateHome && s.promotion_time <= tempDateEnd);
                if (tempData == null)
                {
                    tempStrList.Add(0);
                }
                else
                {
                    tempStrList.Add(tempData.count);
                }

                var tempCorrectionData = correctionList.FirstOrDefault(s => s.end_time >= tempDateHome && s.start_time <= tempDateEnd);
                if (tempCorrectionData == null)
                {
                    tempCorrectionStrList.Add(1);
                }
                else
                {
                    tempCorrectionStrList.Add(tempCorrectionData.param);
                }
            }
            list.Add(tempStrList != null ? tempStrList.ToJson() : "[]");
            list.Add(tempCorrectionStrList != null ? tempCorrectionStrList.ToJson() : "[]");

            ////添加预测销量
            //list.Add(new mforecast {
            //    typename = "预测销量",
            //    today = sales!=null?sales.forecast_today_sales:0,
            //    oneday = sales != null ? sales.oneday_sales : 0,
            //    twoday = sales != null ? sales.twoday_sales : 0,
            //    thirtday = sales != null ? sales.threeday_sales : 0,
            //    forthday = sales != null ? sales.fourthday_sales : 0,
            //    fiveday = sales != null ? sales.fiveday_sales : 0,
            //    sixday = sales != null ? sales.sixday_sales : 0,
            //    sevenday =  sales != null ? sales.sevenday_sales : 0,
            //    eightday = sales!=null?sales.eightday_sales:0,
            //    nineday = sales != null ? sales.nineday_sales : 0,
            //    tenday = sales != null ? sales.tenday_sales : 0,

            //    elevenday = sales != null ? sales.elevenday_sales : 0,
            //    twelveday = sales != null ? sales.twelveday_sales : 0,
            //    thirteenday = sales != null ? sales.thridteenday_sales : 0,
            //    fourteenday = sales != null ? sales.fourteenday_sales : 0,
            //    fifteenday = sales != null ? sales.fifteenday_sales : 0,
            //    sixteenday = sales != null ? sales.sixteenday_sales : 0,
            //    seventeenday = sales != null ? sales.seventeenday_sales : 0,
            //    eighteenday = sales != null ? sales.eighteenday_sales : 0,
            //    nineteenday = sales != null ? sales.nineteenday_sales : 0,
            //    twentyday = sales != null ? sales.twentyday_sales : 0,


            //    twentyoneday = sales != null ? sales.twenty_oneday_sales : 0,
            //    twentytwoday = sales != null ? sales.twenty_twoday_sales : 0,
            //    twentythreeday = sales != null ? sales.twenty_threeday_sales : 0,
            //    twentyfourday = sales != null ? sales.twenty_fourthday_sales : 0,
            //    twentyfiveday = sales != null ? sales.twenty_fiveday_sales : 0,
            //    twentysixday = sales != null ? sales.twenty_sixday_sales : 0,
            //    twentysevenday = sales != null ? sales.twenty_seveneday_sales : 0,
            //    twentyeightday = sales != null ? sales.twenty_eightday_sales : 0,
            //    twentynineday = sales != null ? sales.twenty_nineday_sales : 0,
            //    thirtyday = sales != null ? sales.thirtyday_sales : 0,
            //    skucode = sales != null ? sales.bailun_sku : "",
            //    skuname = "",
            //    warehousecode = sales != null ? sales.warehouse_code : "",
            //    warehousename = sales != null ? sales.warehouse_name : "",
            //});

            ////添加预计入库
            //list.Add(new mforecast {
            //    typename = "预计入库数量",
            //    today = putin!=null?putin.forecast_today_inbound:0,
            //    oneday = putin != null ? putin.forecast_oneday_inbound : 0,
            //    twoday = putin != null ? putin.forecast_twoday_inbound : 0,
            //    thirtday = putin != null ? putin.forecast_threeday_inbound : 0,
            //    forthday = putin != null ? putin.forecast_fourthday_inbound : 0,
            //    fiveday = putin != null ? putin.forecast_fiveday_inbound : 0,
            //    sixday = putin != null ? putin.forecast_sixday_inbound : 0,
            //    sevenday = putin != null ? putin.forecast_sevenday_inbound : 0,
            //    eightday = putin != null ? putin.forecast_eightday_inbound : 0,
            //    nineday = putin != null ? putin.forecast_nineday_inbound : 0,
            //    tenday = putin != null ? putin.forecast_tenday_inbound : 0,

            //    elevenday = putin != null ? putin.forecast_elevenday_inbound : 0,
            //    twelveday = putin != null ? putin.forecast_twelveday_inbound : 0,
            //    thirteenday = putin != null ? putin.forecast_thridteenday_inbound : 0,
            //    fourteenday = putin != null ? putin.forecast_fourteenday_inbound : 0,
            //    fifteenday = putin != null ? putin.forecast_fifteenday_inbound : 0,
            //    sixteenday = putin != null ? putin.forecast_sixteenday_inbound : 0,
            //    seventeenday = putin != null ? putin.forecast_seventeenday_inbound : 0,
            //    eighteenday = putin != null ? putin.forecast_eighteenday_inbound : 0,
            //    nineteenday = putin != null ? putin.forecast_nineteenday_inbound : 0,
            //    twentyday = putin != null ? putin.forecast_twentyday_inbound : 0,


            //    twentyoneday = putin != null ? putin.forecast_twenty_oneday_inbound : 0,
            //    twentytwoday = putin != null ? putin.forecast_twenty_twoday_inbound : 0,
            //    twentythreeday = putin != null ? putin.forecast_twenty_threeday_inbound : 0,
            //    twentyfourday = putin != null ? putin.forecast_twenty_fourthday_inbound : 0,
            //    twentyfiveday = putin != null ? putin.forecast_twenty_fiveday_inbound : 0,
            //    twentysixday = putin != null ? putin.forecast_twenty_sixday_inbound : 0,
            //    twentysevenday = putin != null ? putin.forecast_twenty_seveneday_inbound : 0,
            //    twentyeightday = putin != null ? putin.forecast_twenty_eightday_inbound : 0,
            //    twentynineday = putin != null ? putin.forecast_twenty_nineday_inbound : 0,
            //    thirtyday = putin != null ? putin.forecast_thirtyday_inbound : 0,
            //    skucode = putin != null ? putin.bailun_sku : "",
            //    skuname = "",
            //    warehousecode = putin != null ? putin.warehouse_code : "",
            //    warehousename = "",
            //});

            ////预测可用库存
            //list.Add(new mforecast {
            //    typename = "预测可用库存",
            //    today = inventory != null ? inventory.forecast_today_inventory : 0,
            //    oneday = inventory != null ? inventory.forecast_oneday_inventory : 0,
            //    twoday = inventory != null ? inventory.forecast_twenty_twoday_inventory : 0,
            //    thirtday = inventory != null ? inventory.forecast_threeday_inventory : 0,
            //    forthday = inventory != null ? inventory.forecast_fourthday_inventory : 0,
            //    fiveday = inventory != null ? inventory.forecast_fiveday_inventory : 0,
            //    sixday = inventory != null ? inventory.forecast_sixday_inventory : 0,
            //    sevenday = inventory != null ? inventory.forecast_sevenday_inventory : 0,
            //    eightday = inventory != null ? inventory.forecast_eightday_inventory : 0,
            //    nineday = inventory != null ? inventory.forecast_nineday_inventory : 0,
            //    tenday = inventory != null ? inventory.forecast_tenday_inventory : 0,

            //    elevenday = inventory != null ? inventory.forecast_elevenday_inventory : 0,
            //    twelveday = inventory != null ? inventory.forecast_twelveday_inventory : 0,
            //    thirteenday = inventory != null ? inventory.forecast_thridteenday_inventory : 0,
            //    fourteenday = inventory != null ? inventory.forecast_fourteenday_inventory : 0,
            //    fifteenday = inventory != null ? inventory.forecast_fifteenday_inventory : 0,
            //    sixteenday = inventory != null ? inventory.forecast_sixteenday_inventory : 0,
            //    seventeenday = inventory != null ? inventory.forecast_seventeenday_inventory : 0,
            //    eighteenday = inventory != null ? inventory.forecast_eighteenday_inventory : 0,
            //    nineteenday = inventory != null ? inventory.forecast_nineteenday_inventory : 0,
            //    twentyday = inventory != null ? inventory.forecast_twentyday_inventory : 0,


            //    twentyoneday = inventory != null ? inventory.forecast_twenty_oneday_inventory : 0,
            //    twentytwoday = inventory != null ? inventory.forecast_twenty_twoday_inventory : 0,
            //    twentythreeday = inventory != null ? inventory.forecast_twenty_threeday_inventory : 0,
            //    twentyfourday = inventory != null ? inventory.forecast_twenty_fourthday_inventory : 0,
            //    twentyfiveday = inventory != null ? inventory.forecast_twenty_fiveday_inventory : 0,
            //    twentysixday = inventory != null ? inventory.forecast_twenty_sixday_inventory : 0,
            //    twentysevenday = inventory != null ? inventory.forecast_twenty_seveneday_inventory : 0,
            //    twentyeightday = inventory != null ? inventory.forecast_twenty_eightday_inventory : 0,
            //    twentynineday = inventory != null ? inventory.forecast_twenty_nineday_inventory : 0,
            //    thirtyday = inventory != null ? inventory.forecast_thirtyday_inventory : 0,
            //    skucode = inventory != null ? inventory.bailun_sku : "",
            //    skuname = "",
            //    warehousecode = inventory != null ? inventory.warehouse_code : "",
            //    warehousename = "",
            //});

            ////预测缺货数
            //list.Add(new mforecast {
            //    typename = "预测缺货数量",
            //    today = shortsupply != null ? shortsupply.forecast_today_short_supply : 0,
            //    oneday = shortsupply != null ? shortsupply.forecast_oneday_short_supply : 0,
            //    twoday = shortsupply != null ? shortsupply.forecast_twenty_twoday_short_supply : 0,
            //    thirtday = shortsupply != null ? shortsupply.forecast_threeday_short_supply : 0,
            //    forthday = shortsupply != null ? shortsupply.forecast_fourthday_short_supply : 0,
            //    fiveday = shortsupply != null ? shortsupply.forecast_fiveday_short_supply : 0,
            //    sixday = shortsupply != null ? shortsupply.forecast_sixday_short_supply : 0,
            //    sevenday = shortsupply != null ? shortsupply.forecast_sevenday_short_supply : 0,
            //    eightday = shortsupply != null ? shortsupply.forecast_eightday_short_supply : 0,
            //    nineday = shortsupply != null ? shortsupply.forecast_nineday_short_supply : 0,
            //    tenday = shortsupply != null ? shortsupply.forecast_tenday_short_supply : 0,

            //    elevenday = shortsupply != null ? shortsupply.forecast_elevenday_short_supply : 0,
            //    twelveday = shortsupply != null ? shortsupply.forecast_twelveday_short_supply : 0,
            //    thirteenday = shortsupply != null ? shortsupply.forecast_thridteenday_short_supply : 0,
            //    fourteenday = shortsupply != null ? shortsupply.forecast_fourteenday_short_supply : 0,
            //    fifteenday = shortsupply != null ? shortsupply.forecast_fifteenday_short_supply : 0,
            //    sixteenday = shortsupply != null ? shortsupply.forecast_sixteenday_short_supply : 0,
            //    seventeenday = shortsupply != null ? shortsupply.forecast_seventeenday_short_supply : 0,
            //    eighteenday = shortsupply != null ? shortsupply.forecast_eighteenday_short_supply : 0,
            //    nineteenday = shortsupply != null ? shortsupply.forecast_nineteenday_short_supply : 0,
            //    twentyday = shortsupply != null ? shortsupply.forecast_twentyday_short_supply : 0,


            //    twentyoneday = shortsupply != null ? shortsupply.forecast_twenty_oneday_short_supply : 0,
            //    twentytwoday = shortsupply != null ? shortsupply.forecast_twenty_twoday_short_supply : 0,
            //    twentythreeday = shortsupply != null ? shortsupply.forecast_twenty_threeday_short_supply : 0,
            //    twentyfourday = shortsupply != null ? shortsupply.forecast_twenty_fourthday_short_supply : 0,
            //    twentyfiveday = shortsupply != null ? shortsupply.forecast_twenty_fiveday_short_supply : 0,
            //    twentysixday = shortsupply != null ? shortsupply.forecast_twenty_sixday_short_supply : 0,
            //    twentysevenday = shortsupply != null ? shortsupply.forecast_twenty_seveneday_short_supply : 0,
            //    twentyeightday = shortsupply != null ? shortsupply.forecast_twenty_eightday_short_supply : 0,
            //    twentynineday = shortsupply != null ? shortsupply.forecast_twenty_nineday_short_supply : 0,
            //    thirtyday = shortsupply != null ? shortsupply.forecast_thirtyday_short_supply : 0,
            //    skucode = shortsupply != null ? shortsupply.bailun_sku : "",
            //    skuname = "",
            //    warehousecode = shortsupply != null ? shortsupply.warehouse_code : "",
            //    warehousename = "",
            //});

            return list;
        }


    }
}
