﻿using AutoTurnOver.DB;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using MySql.Data.MySqlClient;
using AutoTurnOver.Models;
using Dapper;

namespace AutoTurnOver.Services
{
    /// <summary>
    /// 采购平均指标计算
    /// </summary>
    public class PurchaseAverageTargetServices
    {
        /// <summary>
        /// 取数基数
        /// </summary>
        public static int _seed_count = 5;

        public static void Calculation()
        {
            MySqlConnection conn = connectionHelper._connection;

            var task_log = new dc_task_log
            {
                StartTime = DateTime.Now,
                Type = 1,
                Count = 0
            };

            var taskID = conn.Insert(task_log);
            task_log.ID = taskID.Value;

            try
            {

                // 获取最近2天发送变化的SKU 用于计算
                var chageSkuList = AveragePurchase.GetChangeSku(2);
                foreach (var skuItem in chageSkuList)
                {
                    dc_average_purchase data = new dc_average_purchase()
                    {
                        bailun_sku = skuItem.bailun_sku,
                        supplier_id = skuItem.supplier_id ?? 0
                    };
                    


                    // 查询相关采购单
                    var purchaseList = AveragePurchase.GetPurchaseList(skuItem, _seed_count).ToList();

                    //有相关采购单
                    if (purchaseList != null && purchaseList.Count() >= 1)
                    {
                        data.supplier_name = purchaseList[0].supplier_name;

                        //计算平均价格
                        data.price = purchaseList.Sum(s => s.price ?? 0) / purchaseList.Count;

                        // 计算平均到货天数
                        // 计算总交期
                        int delivery_days = 0;
                        // 查询相关的到货记录
                        var arrivalList = AveragePurchase.GetArrivalList(purchaseList.Select(s => s.purchase_id), skuItem.bailun_sku);
                        foreach (var itemArrivalList in arrivalList.GroupBy(s => s.purchase_id))
                        {
                            var tempPurchase = purchaseList.SingleOrDefault(s => s.purchase_id == itemArrivalList.Key);

                            if (tempPurchase.pay_type == 1)
                            {
                                delivery_days += (int)(itemArrivalList.Max(s => s.update_time) - tempPurchase.pay_time).Value.TotalDays;
                            }
                            else
                            {
                                delivery_days += (int)(itemArrivalList.Max(s => s.update_time) - tempPurchase.confirm_time).Value.TotalDays;
                            }
                        }

                        // 平均采购交期
                        data.delivery_days = delivery_days / purchaseList.Count;

                        

                       

                        //写入数据库
                        AveragePurchase.Save(data, conn);

                        task_log.Count++;
                    }

                    var purchaseWList = AveragePurchase.GetPurchaseListByWode(skuItem, _seed_count).ToList();

                    if (purchaseWList != null && purchaseWList.Count() >= 1)
                    {
                        dc_average_warehouse dataWarehouse = new dc_average_warehouse()
                        {
                            bailun_sku = skuItem.bailun_sku,
                            warehouse_code = skuItem.warehouse_code
                        };
                        // 计算平均入库天数
                        // 查询相关的入库记录
                        var inbound_days = 0;
                        var inboundList = AveragePurchase.GetInboundList(purchaseWList.Select(s => s.purchase_id), skuItem.bailun_sku);
                        foreach (var itemInboundList in inboundList.GroupBy(s => s.purchase_id))
                        {
                            var tempPurchase = purchaseWList.SingleOrDefault(s => s.purchase_id == itemInboundList.Key);

                            if (tempPurchase.pay_type == 1)
                            {
                                inbound_days += (int)(itemInboundList.Max(s => s.update_time) - tempPurchase.pay_time).Value.TotalDays;
                            }
                            else
                            {
                                inbound_days += (int)(itemInboundList.Max(s => s.update_time) - tempPurchase.confirm_time).Value.TotalDays;
                            }
                        }

                        // 平均入库天数
                        dataWarehouse.inbound_days = inbound_days / purchaseWList.Count;
                        AveragePurchase.Save(dataWarehouse, conn);
                    }


                }

                task_log.CompleteTime = DateTime.Now;
            }
            catch (Exception ex)
            {
                task_log.ErrorMsg = ex.Message;
            }

            conn.Update(task_log);
        }

        public static IEnumerable<dc_average_purchase> GetList(string sku)
        {
            return AveragePurchase.GetList(sku);
        }

        public static IEnumerable<dc_average_purchase> GetList(string supplier_ids, string bailun_skus)
        {
            return AveragePurchase.GetList(supplier_ids, bailun_skus);
        }

        public static dc_average_warehouse GetWarehouse(string sku, string warehouse_code)
        {
            return AveragePurchase.GetWarehouse(sku, warehouse_code);
        }



    }


}
