﻿using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Services
{
    public class ConfigServices
    {
        #region 安全库存规则配置

        /// <summary>
        /// 获取安全库存规则设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_safe_inventoryDto> InventoryList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.InventoryList(m, offset, limit, ref total);
        }


        /// <summary>
        /// 保存安全库存规则
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveInventory(Models.dc_auto_config_safe_inventory m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }
            m.warehouse_name = objWarehouse.warehouse_name;

            if (m.type == (int)Safe_inventoryType.仓库_SKU_定值)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "Sku不能为空！";
                }
                if (m.param <= 0)
                {
                    return "安全库存必填";
                }
            }
            else if (m.type == (int)Safe_inventoryType.仓库_分类_定值)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "请选择分类";
                }
                if (m.param <= 0)
                {
                    return "安全库存必填";
                }
                var cID = 0;
                if(!int.TryParse(m.variable_code,out cID))
                {
                    return "请选择分类";
                }
                var cModel = ApiServices.GetCategoryById(cID);
                m.variable_name = cModel.C_CNAME;
            }
            else if (m.type==(int)Safe_inventoryType.仓库_SKU_按历史计算 || m.type == (int)Safe_inventoryType.仓库_SKU_按预测计算)
            {
                if (string.IsNullOrWhiteSpace(m.variable_code))
                {
                    return "Sku不能为空！";
                }
                if (m.weighting_coefficient_seven <= 0)
                {
                    return "请填写7天权重";
                }
                if (m.weighting_coefficient_fourteen <= 0)
                {
                    return "请填写14天权重";
                }
                if (m.weighting_coefficient_thirty <= 0)
                {
                    return "请填写30天权重";
                }
                if (m.weighting_coefficient_thirty + m.weighting_coefficient_seven + m.weighting_coefficient_fourteen != 1)
                {
                    return "三个权重加起来不等于 1";
                }
            }




            if (m.type == 1 || m.type == 11 || m.type == 12)
            {
                var objProduct = DB.common.GetPrductBySku(m.variable_code);
                if (objProduct == null)
                {
                    return "系统找不到该Sku。";
                }
                m.variable_name = objProduct.sku_title_cn;
            }


            return DB.db_config.SaveInventory(m, username);
        }



        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_safe_inventory GetInventoryById(int id)
        {
            return DB.db_config.GetInventoryById(id);
        }

        #endregion

        #region 销量上限配置

        /// <summary>
        /// 获取销量上限设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_sales_upper_limit> SalesUpperLimitList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.db_config.SalesUpperLimitList(m, offset, limit, ref total);
        }


        /// <summary>
        /// 保存销量上限
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveSalesUpperLimit(Models.dc_auto_config_sales_upper_limit m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }
            m.warehouse_name = objWarehouse.warehouse_name;

            var objProduct = DB.common.GetPrductBySku(m.bailun_sku);
            if (objProduct == null)
            {
                return "系统找不到该Sku。";
            }
            m.sku_name = objProduct.sku_title_cn;

            if (m.value_or_coefficient <= 0)
            {
                return "销量上线不可小于0";
            }

            return DB.db_config.SaveSalesUpperLimit(m, username);
        }



        /// <summary>
        /// 获取销量上限设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_sales_upper_limit GetSalesUpperLimitById(int id)
        {
            return DB.db_config.GetSalesUpperLimitById(id);
        }

        #endregion
    }
}
