﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// sku自动周转
    /// </summary>
    public class dc_auto_turnover
    {
        public int id { get; set; }

        /// <summary>
        /// 建议单单号
        /// </summary>
        public string purchase_advice_id { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 建议采购数
        /// </summary>
        public int quantity_init_advise { get; set; }

        /// <summary>
        /// 最小订单数量
        /// </summary>
        public int quantity_minimum_order { get; set; }

        /// <summary>
        /// 跟MOQ对比后最终的的自动采购建议
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }
        
        /// <summary>
        /// 活动促销数量
        /// </summary>
        public int quantity_promotion { get; set; }

        /// <summary>
        /// 实际库存数量
        /// </summary>
        public int quantity_inventory { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        public int quantity_safe_inventory { get; set; }
        

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 正常为0, 缺货为1
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 记录时间
        /// </summary>
        public DateTime record_time { get; set; }

        /// <summary>
        /// 与dc_auto_config_promotion的id关联,以逗号分隔
        /// </summary>
        public string promotions { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 调拨交运时长
        /// </summary>
        public int transfer_delivery { get; set; }

        /// <summary>
        /// 质检入库时长
        /// </summary>
        public int inspection_delivery { get; set; }
        /// <summary>
        /// 未来7天日均
        /// </summary>

        public int forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 未来14天日均
        /// </summary>
        public int forecast_fourteenday_sales { get; set; }

        /// <summary>
        /// 七天实际销量+预测销量
        /// </summary>
        public string sales_details { get; set; }

    }

    public class Condition_AutoTurnOver
    {
        /// <summary>
        /// SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 是否缺货
        /// </summary>
        public int? out_of_stock { get; set; }

        /// <summary>
        /// 是否冗余
        /// </summary>
        public int? redundancy { get; set; }
    }

    public class dc_auto_turnover_Extend : dc_auto_turnover
    {
        /// <summary>
        ///昨日销量
        /// </summary>
        public int oneday_sales { get; set; }

        /// <summary>
        /// 预测明日销量
        /// </summary>
        public int forecast_oneday_sales2 { get; set; }

        
    }
}
