﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_auto_order
    {
        public int id { get; set; }

        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 到货仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 到货仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 调拨仓库编码
        /// </summary>
        public string warehouse_code_to { get; set; }

        /// <summary>
        /// 调拨仓库名称
        /// </summary>
        public string warehouse_name_to { get; set; }

        /// <summary>
        /// 下单类型，1：采购单
        /// </summary>
        public int type { get; set; }

        /// <summary>
        /// 下单数量
        /// </summary>
        public int buycount { get; set; }

        /// <summary>
        /// 下单价格
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 供应商id
        /// </summary>
        public int supplierid { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string suppliername { get; set; }

        /// <summary>
        /// 预计到货时间
        /// </summary>
        public DateTime arrivaltime { get; set; }

        /// <summary>
        /// 采购员
        /// </summary>
        public string buyer { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createtime { get; set; }

        /// <summary>
        /// 创建人名称
        /// </summary>
        public string createusername { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string note { get; set; }

        /// <summary>
        /// 采购单id
        /// </summary>
        public int buyid { get; set; }

        /// <summary>
        /// 采购单号
        /// </summary>
        public string buyno { get; set; }

        /// <summary>
        /// 状态：-1：作废，0：未下单，1：已提交，2：下单成功
        /// </summary>
        public int status { get; set; }
    }

    public class Condition_AutoOrder
    {
        public string sku { get; set; }

        public string warehousecode { get; set; }
    }

    /// <summary>
    /// 下单类型
    /// </summary>
    public enum EnumAutoOrderType
    {
        采购单 = 1
    }

}
