﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_auto_config_promotion
    {
        public int id { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }
        
        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 活动日期
        /// </summary>
        public DateTime promotion_time { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 审核人
        /// </summary>
        public string bl_auditor { get; set; }

        /// <summary>
        /// 操作人
        /// </summary>
        public string bl_operator { get;set;}

        /// <summary>
        /// 页面显示的时间
        /// </summary>
        //public string vtime { get; set; }
    }

    /// <summary>
    /// 特殊销售规则设置搜索条件
    /// </summary>
    public class Condition_ConfigPromotion
    {
        /// <summary>
        /// sku编码
        /// </summary>
        public string sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehousecode { get; set; }

        /// <summary>
        /// 状态 0：默认, 1：有关联采购建议，2：作废 
        /// </summary>
        public int? status { get; set; }

        public string vstatus { get; set; }

        /// <summary>
        /// 是否过期
        /// </summary>
        public bool? IsEffective { get; set; }

    }

    /// <summary>
    /// 特殊销售规则状态
    /// </summary>
    public enum EnumSaleSettingStatus {
        待应用 = 0,
        已应用 = 1,
        作废 = 2
    }

    public class dc_auto_config_promotion_input
    {
        public string sku { get; set; }

        public string warehousecode { get; set; }

        public string warehouse_name { get; set; }

        public DateTime time { get; set; }

        public int count { get; set; }

        public string note { get; set; }
    }

}
