﻿using AutoTurnOver.Models;
using Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.DB
{
    public class daily : connectionHelper
    {
        /// <summary>
        /// 查询采购在途数据
        /// </summary>
        /// <param name="sku">sku</param>
        /// <param name="warehouse_code">仓库编码</param>
        /// <returns></returns>
        public static IEnumerable<dc_purchase_daily_dto> List(string sku, string warehouse_code)
        {
            var sql = @" 
select 
t1.create_time,
t1.bailun_sku,
t1.sku_name,
t1.purchase_id,
t1.warehouse_code,
t1.warehouse_name,
t1.count as 'purchaseQuantity',
t2.inboundQuantity
from dc_base_purchase as t1
left join (
	select t2_1.purchase_id,t2_1.warehouse_code,t2_1.bailun_sku,sum(t2_1.count) as 'inboundQuantity' from dc_base_purchase_inbound as t2_1 
    where t2_1.warehouse_code=@warehouse_code and t2_1.bailun_sku=@bailun_sku
    GROUP BY t2_1.warehouse_code,t2_1.bailun_sku,t2_1.purchase_id
) as t2 on t1.bailun_sku = t2.bailun_sku and t1.warehouse_code = t2.warehouse_code and t1.purchase_id = t2.purchase_id
where t1.count>t2.inboundQuantity and t1.warehouse_code=@warehouse_code and t1.bailun_sku=@bailun_sku
";
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("bailun_sku", sku);
            parameters.Add("warehouse_code", warehouse_code);
            return _connection.Query<dc_purchase_daily_dto>(sql, parameters);
        }


        /// <summary>
        /// 查询时实库存数据
        /// </summary>
        /// <param name="sku">sku</param>
        /// <param name="warehouse_code">仓库编码</param>
        /// <returns></returns>
        public static IEnumerable<dc_realtime_purchase_daily_dto> RealtimeList(string sku, string warehouse_code,string product_inner_code,string sku_title_cn, int offset, int limit, ref int total)
        {
            var sql = @" 
select
t1.warehouse_code,
t1.warehouse_name,
t1.bailun_sku,
t2.sku_name,
t1.quantity_avaliable,
t1.quantity_occupied,
t1.quantity_virtual,
t1.quantity_process,
t2.quantity as 'purchase_daily_quantity',
t3.buyer_name,t3.sku_title_cn,t3.sku_title_en,t3.product_inner_code
from dc_daily_inventory as t1
left join ( select * from dc_daily_purchase where record_time>=@time and type=1) as t2 on t1.warehouse_code = t2.warehouse_code and t1.bailun_sku = t2.bailun_sku
left join dc_base_sku as t3 on t1.bailun_sku = t3.bailun_sku
where 1=1
";

            var countSql = @" 
select
count(1)
from dc_daily_inventory as t1
left join ( select * from dc_daily_purchase where record_time>=@time and type=1) as t2 on t1.warehouse_code = t2.warehouse_code and t1.bailun_sku = t2.bailun_sku
left join dc_base_sku as t3 on t1.bailun_sku = t3.bailun_sku
where 1=1
";
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("time", DateTime.Now.ToString("yyyy-MM-dd 00:00:00"));
            if (!string.IsNullOrWhiteSpace(product_inner_code))
            {
                sql += " and t3.product_inner_code like @product_inner_code ";
                countSql += " and t3.product_inner_code like @product_inner_code ";

                parameters.Add("product_inner_code", $"%{product_inner_code}%");
            }
            if (!string.IsNullOrWhiteSpace(sku_title_cn))
            {
                sql += " and t3.sku_title_cn like @sku_title_cn ";
                countSql += " and t3.sku_title_cn like @sku_title_cn ";

                parameters.Add("sku_title_cn", $"%{sku_title_cn}%");
            }
            if (!string.IsNullOrWhiteSpace(sku))
            {
                sql += " and t1.bailun_sku=@bailun_sku ";
                countSql += " and t1.bailun_sku=@bailun_sku ";

                parameters.Add("bailun_sku", sku);
            }
            if (!string.IsNullOrWhiteSpace(warehouse_code))
            {
                sql += " and t1.warehouse_code=@warehouse_code ";
                countSql += " and t1.warehouse_code=@warehouse_code ";
                parameters.Add("warehouse_code", warehouse_code);
            }


            var obj = _connection.Query<dc_realtime_purchase_daily_dto>(sql + " limit " + offset + "," + limit, parameters);
            total = _connection.QueryFirst<int>(countSql, parameters);
            return obj.AsList();
        }

    }
}
