﻿using AutoTurnOver.DB.Base;
using AutoTurnOver.Models;
using AutoTurnOver.Models.Base;
using Dapper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AutoTurnOver.DB
{
   public class api_dao : connectionHelper
    {
        /// <summary>
        /// 获取缺货数据
        /// </summary>
        /// <param name="search"></param>
        /// <returns></returns>
        public static Page<dc_quantity_out_stock_dto> GetOutStockPage(dc_quantity_out_stock_search_dto search)
        {
            string sql = " select  *  from dc_mid_transit as t1 where 1=1 ";
            DynamicParameters parameters = new DynamicParameters();
            if (search != null)
            {
                if (search.btime != null)
                {
                    sql += " and t1.gmt_out_stock_modified>=@btime ";
                    parameters.Add("btime",search.btime);
                }
                if (search.etime != null)
                {
                    sql += " and t1.gmt_out_stock_modified<=@etime ";
                    parameters.Add("etime", search.etime);
                }
            }
            return _connection.Page<dc_quantity_out_stock_dto>(sql, search, parameters);
        }

        public static async Task<IEnumerable<dc_base_oms_sku_full_dto>> GetOmsSkuFullPage(dc_base_oms_sku_full_search_dto search)
        {
            if (search.page <= 0)
            {
                search.page = 1;
            }
            var sql = " select t1.* from dc_base_oms_sku as t1 where 1=1 ";
            DynamicParameters parameters = new DynamicParameters();
            if (!string.IsNullOrWhiteSpace(search.warehouse_codes))
            {
                sql += " and t1.warehouse_code in @warehouse_codes ";
                parameters.Add("warehouse_codes", search.warehouse_codes.Split(',').ToList());
            }
            if (search.btime != null)
            {
                sql += " and t1.gmt_modified >=@btime ";
                parameters.Add("btime", search.btime);
            }
            if (search.etime != null)
            {
                sql += " and t1.gmt_modified <=@etime ";
                parameters.Add("etime", search.etime);
            }
            return await _connection.QueryAsync<dc_base_oms_sku_full_dto>(sql+ $" limit {(search.page - 1) * search.rows},{search.rows} ", parameters);
        }

        // <summary>
        /// 查询sku销量
        /// </summary>
        /// <param name="search"></param>
        /// <returns></returns>
        public static Page<api_sku_sales_volume_dto> GetSkuSalesVolume(api_sku_sales_volume_search_dto search)
        {
            string sql = " select  t1.bailun_sku,t1.warehouse_code,t1.history_sevenday_sales from dc_auto_turnover as t1 where 1=1 ";
            DynamicParameters parameters = new DynamicParameters();
            if (search != null)
            {
                if (search.bailun_sku_list != null && search.bailun_sku_list.Count >= 1)
                {
                    sql += " and t1.bailun_sku in @bailun_skus ";
                    parameters.Add("bailun_skus", search.bailun_sku_list);
                }
            }
            return _connection.Page<api_sku_sales_volume_dto>(sql, search, parameters);
        }
    }
}
