﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AutoTurnOver.Models
{
    public class TokenResult
    {
        /// <summary>
        /// 返回状态
        /// </summary>
        public bool result { get; set; }

        /// <summary>
        /// 返回信息
        /// </summary>
        public string message { get; set; }
    }

    public class tokenUser
    {
        public SaasUserInfo result { get; set; }

        public int statusCode { get; set; }
    }

    public class SaasUserInfo
    {
        public bool success { get; set; }
        public string Account { get; set; }
        public int UserId { get; set; }
        public bool AllCompany { get; set; }
        public List<tokenRole> roles { get; set; }
        public CompanyInfo Company { get; set; }
        //public DepartmentInfo Department { get; set; }
        public bool has_admin { get; set; }

        public List<saas_menu_info_dto> menuInfoDtos { get; set; }

        public List<tree_menu_dto> tree_menu_list()
        {
            if (menuInfoDtos == null) return new List<tree_menu_dto>();
            else
            {
                return menuInfoDtos.Where(s => s.isshow == true && s.menuFatherCode == "None").Select(s => new tree_menu_dto
                {
                    url = s.html_url,
                    name = s.menuName,
                    child = menuInfoDtos.Where(v => s.menuCode == v.menuFatherCode).Select(v => new tree_menu_dto
                    {
                        url = v.html_url,
                        name = v.menuName
                    }).ToList()
                }).ToList();
            }
        }

        public class tree_menu_dto
        {
            public string url { get; set; }
            public string name { get; set; }
            public List<tree_menu_dto> child { get; set; }

        }
    }

    public class saas_result_dto<T>
    {
        public T result { get; set; }

        public int statusCode { get; set; }

        public string message { get; set; }
    }
    public class Saas_MenusDto
    {
        public List<saas_menu_info_dto> menuInfoDtos { get; set; }
        public bool success { get; set; }

        public string projectCode { get; set; }
    }

    public class saas_menu_info_dto
    {
        public string menuCode { get; set; }

        public string menuName { get; set; }

        public string menuUrl { get; set; }

        private List<string> _menuUrl_list;
        public List<string> menuUrl_list { get {
                if (_menuUrl_list == null)
                {
                    if (menuUrl != null)
                    {
                        _menuUrl_list = menuUrl.Split('|').ToList();
                    }
                   
                }
                return _menuUrl_list;
            } }

        /// <summary>
        /// 用于前端显示的地址
        /// </summary>
        public string html_url { get
            {
                if(menuUrl_list!=null && menuUrl_list.Count >= 1)
                {
                    return menuUrl_list[0];
                }
                else
                {
                    return null;
                }
            } }

        public string menuIco { get; set; }

        public string menuFatherCode { get; set; }

        public int mMenuLevel { get; set; }

        public bool? isshow { get; set; }
    }
    public class tokenRole
    {
        public int Id { get; set; }
        public string RoleCode { get; set; }
        public string RoleName { get; set; }
    }
    public class DepartmentInfo
    {
        public int DepartmentId { get; set; }
        public string Name { get; set; }
        public string Code { get; set; }
    }
    public class CompanyInfo
    {
        public int Id { get; set; }
        public string CompanyCode { get; set; }
        public string CompanyName { get; set; }
    }
}
