﻿using AutoTurnOver.DB.Base;
using AutoTurnOver.Models;
using AutoTurnOver.Models.Base;
using Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.DB
{
    public class dc_auto_stock_monitor_dao : connectionHelper
    {
        public static Page<dc_auto_stock_monitor_dto> GetPage(dc_auto_stock_monitor_search_dto search)
        {
            string sql = @" select
t1.bailun_sku,
t1.product_code,
t1.sku_title_cn,
t1.develop_time,
t1.push_time,
t1.product_type_desc,
t1.source,
t1.unit_price,
t1.buyer_name,
t1.weight,
( case when t5.bailun_sku is not null then '监控中' else '停止监控' end ) as 'monitor_status',
t2.*,
t1.`status` 
from dc_view_stock_monitor_sku as tv
inner join dc_base_sku as t1 on t1.bailun_sku = tv.bailun_sku 
left join dc_auto_stock_monitor as t2 on t1.bailun_sku = t2.bailun_sku
left join dc_auto_monitor_sku as t5 on t1.bailun_sku = t5.bailun_sku 
where 1=1 ";
            DynamicParameters parameters = new DynamicParameters();
            if (search != null)
            {
                if(search.start_date!=null && search.end_date != null)
                {
                    sql += "  and EXISTS (select * from dc_base_stock_record as t_re where tv.bailun_sku = t_re.bailun_sku and t_re.stock_time>=@start_date and t_re.stock_time<=@end_date and has_transfer=1 ) ";
                    parameters.Add("start_date", search.start_date.Value.ToString("yyyy-MM-dd 00:00:00"));
                    parameters.Add("end_date", search.start_date.Value.ToString("yyyy-MM-dd 23:59:59"));
                }
                else if (search.start_date != null)
                {
                    sql += "  and EXISTS (select * from dc_base_stock_record as t_re where tv.bailun_sku = t_re.bailun_sku and t_re.stock_time>=@start_date and has_transfer=1 ) ";
                    parameters.Add("start_date", search.start_date.Value.ToString("yyyy-MM-dd 00:00:00"));
                }else if (search.end_date != null)
                {
                    sql += "  and EXISTS (select * from dc_base_stock_record as t_re where tv.bailun_sku = t_re.bailun_sku  and t_re.stock_time<=@end_date and has_transfer=1 ) ";
                    parameters.Add("end_date", search.start_date.Value.ToString("yyyy-MM-dd 23:59:59"));
                }
                if (search.bailun_sku != null)
                {
                    sql += " and t1.bailun_sku=@bailun_sku ";
                    parameters.Add("bailun_sku", search.bailun_sku);
                }
                if (search.type==1)
                {
                    sql += " and t2.haiwai_us_usable_stock>0 ";
                }else if(search.type == 2)
                {
                    sql += " and t2.haiwai_uk_usable_stock>0 ";
                }else if(search.type == 3)
                {
                    sql += " and t2.guangzhou01_transfer_stock<=0 ";
                }else if(search.type == 4)
                {
                    sql += " and t2.haiwai_us_transfer<=0 ";
                }else if(search.type == 5)
                {
                    sql += " and t2.haiwai_uk_transfer<=0 ";
                }
            }
            return _connection.Page<dc_auto_stock_monitor_dto>(sql, search, parameters);
        }
    }
}
