﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;

namespace AutoTurnOver.Utility
{
    public enum RequestType
    {
        GET,
        POST
    }
    public class HttpHelper
    {
        public static string Request(string url, RequestType type, string data = "", string entype = null, int timeout = 0)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            if (timeout <= 0)
            {
                request.Timeout = 1000 * 30 ;
            }
            else
            {
                request.Timeout = timeout;
            }

            request.UserAgent =
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.116 Safari/537.36";
            request.Accept = "*";

            switch (type)
            {
                case RequestType.GET:
                    if (string.IsNullOrWhiteSpace(request.ContentType))
                        request.ContentType = "text/html; charset=UTF-8";
                    request.Method = "GET";
                    break;

                case RequestType.POST:
                    {
                        if (string.IsNullOrWhiteSpace(entype))
                            request.ContentType = "application/x-www-form-urlencoded; charset=UTF-8";
                        else
                            request.ContentType = entype;

                        request.Method = "POST";
                        byte[] bytes = Encoding.UTF8.GetBytes(data);
                        request.ContentLength = bytes.Length;
                        Stream requestStream = request.GetRequestStream();
                        requestStream.Write(bytes, 0, bytes.Length);
                        requestStream.Close();
                        break;
                    }
                default:
                    request.ContentType = "text/html; charset=UTF-8";
                    break;
            }
            StringBuilder builder = new StringBuilder();
            HttpWebResponse response = (HttpWebResponse)request.GetResponse();
            Stream responseStream = response.GetResponseStream();
            StreamReader reader = new StreamReader(responseStream, Encoding.UTF8);
            while (reader.Peek() != -1)
            {
                builder.Append(reader.ReadLine());
            }
            responseStream.Dispose();
            reader.Close();
            response.Close();

            return builder.ToString();
        }
    }
}
