﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace AutoTurnOver.Models.Report
{
    /// <summary>
    /// 缺货明细
    /// </summary>
    public class quantity_out_stock_detail_dto
    {
        /// <summary>
        /// 缺货更新时间
        /// </summary>
        public DateTime? gmt_out_stock_modified { get; set; }

        /// <summary>
        /// 平台订单号
        /// </summary>
        public string origin_order_id { get; set; }

        /// <summary>
        /// 平台
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 百伦订单号
        /// </summary>
        public string bailun_order_id { get; set; }

        /// <summary>
        /// 付款交易号
        /// </summary>
        public string transaction_id { get; set; }

        public string website { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public DateTime? pay_time { get; set; }

        /// <summary>
        /// 销售账号
        /// </summary>
        public string seller_account { get; set; }

        /// <summary>
        /// 国家
        /// </summary>
        public string receipt_country { get; set; }

        /// <summary>
        /// sku
        /// </summary>
        public string bailun_sku { get; set; }

        public string sku_name { get; set; }

        /// <summary>
        /// 订单销量
        /// </summary>
        public decimal bailun_sku_quantity_ordered { get; set; }

        public string warehouse_code { get; set; }

        public string warehouse_name { get; set; }

        public string is_out_stock { get; set; }

        /// <summary>
        /// 仓库总缺货
        /// </summary>
        public decimal? quantity_out_stock { get; set; }

        /// <summary>
        /// 国内仓可用库存
        /// </summary>
        public decimal? sum_usable_stock { get; set; }

        /// <summary>
        /// 国内仓待发货数量
        /// </summary>
        public decimal? sum_unshipped_quantity { get; set; }

        /// <summary>
        /// 国内仓累计缺货
        /// </summary>
        public decimal? sum_quantity_out_stock { get; set; }

        /// <summary>
        /// 国内有库存的仓库
        /// </summary>
        public string warehouse_codes { get; set; }

        /// <summary>
        /// 国内仓其他有库存仓库
        /// </summary>
        public string other_codes
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(warehouse_codes))
                {

                    return warehouse_codes.Replace(warehouse_code, "");
                }
                else
                {
                    return null;
                }
            }
        }

        /// <summary>
        /// 其他国内仓总库存
        /// </summary>
        public decimal? other_stock { get; set; }

        /// <summary>
        /// 国内仓总库存是否缺货
        /// </summary>
        public string is_sum_quantity_out_stock { get; set; }

        /// <summary>
        /// 采购员
        /// </summary>
        public string buyer_name { get; set; }

        /// <summary>
        /// 平台指定物流
        /// </summary>
        public string bailun_require_logistics { get; set; }

        /// <summary>
        /// 发货物流方式
        /// </summary>
        public string logistics_method_name { get; set; }

        /// <summary>
        /// 监控状态
        /// </summary>
        public string monitor_status { get; set; }

        /// <summary>
        /// 停售状态
        /// </summary>
        public string sku_status { get; set; }

        /// <summary>
        /// 总在途
        /// </summary>
        public decimal? quantity_ontheway { get; set; }

        /// <summary>
        /// 在途数据
        /// </summary>
        public string buy_ontheway_detail { get; set; }
        public buy_ontheway_detail_dto min_buy { get {
                if (buy_ontheway_detail_list.Count <= 0) return new buy_ontheway_detail_dto { };
                else
                {
                    return buy_ontheway_detail_list.OrderBy(s => s.arrival_date).FirstOrDefault();
                }
            } }
        public List<buy_ontheway_detail_dto> buy_ontheway_detail_list
        {
            get
            {
                if (string.IsNullOrWhiteSpace(buy_ontheway_detail))
                {
                    return new List<buy_ontheway_detail_dto>();
                }
                else
                {
                    var datas = new List<buy_ontheway_detail_dto>();
                    foreach (var buy_str in buy_ontheway_detail.Split(','))
                    {
                        var temp_sry  = buy_str.Replace("【", "").Replace("】", "");
                        var buy_array = temp_sry.Split('|');// Trim() 
                        datas.Add(new buy_ontheway_detail_dto {
                            no = buy_array[0].Trim(),
                            count = int.Parse(buy_array[1].Trim()),
                            inbound = int.Parse(buy_array[2].Trim()),
                            arrival_date = DateTime.Parse(buy_array[3].Trim()),
                            supplier_name = buy_array[4].Trim(),
                            alibaba_order_id = buy_array[5].Trim(),
                            logistics_order_id = buy_array[6].Trim(),
                        });
                    }

                    return datas;
                }
            }
        }

        public int sum_order_count { get; set; }
        public int sum_sku_count { get; set; }
    }
    
    public class quantity_out_stock_detail_search_dto
    {
        public string bailun_sku { get; set; }

        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }

        public string warehouse_code { get; set; }

        public string product_inner_code { get; set; }

        public string purchase_user { get; set; }
        public int? bailun_account_id { get; set;}
        public bool isSum { get; set; }

    }

    public class buy_ontheway_detail_dto
    {
        public string no { get; set; }
        public int count { get; set; }
        public int inbound { get; set; }
        public DateTime arrival_date { get; set; }

        public string supplier_name { get; set; }

        public string alibaba_order_id { get; set; }

        public string logistics_order_id { get; set; }
    }
}
