﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_base_stock
    {
        public int id { get; set; }

        public string bailun_sku { get; set; }

        public string warehouse_code { get; set; }

        /// <summary>
        /// 货主编码
        /// </summary>
        public string owner_code { get; set; }

        /// <summary>
        /// 订货数量
        /// </summary>
        public int quantity_reservation { get; set; }

        /// <summary>
        /// 运输在途
        /// </summary>
        public int quantity_transport { get; set; }

        /// <summary>
        /// 中转仓库存
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 冻结库存
        /// </summary>
        public int quantity_freeze { get; set; }

        /// <summary>
        /// 供应商库存
        /// </summary>
        public int quantity_supplier { get; set; }

        /// <summary>
        /// 预售库存
        /// </summary>
        public int quantity_presell { get; set; }

        /// <summary>
        /// 不良品库存
        /// </summary>
        public int quantity_defective { get; set; }

        /// <summary>
        /// 在途库存
        /// </summary>
        public int quantity_transit { get; set; }

        /// <summary>
        /// 收货待检
        /// </summary>
        public int wait_check { get; set; }

        /// <summary>
        /// 待上架
        /// </summary>
        public int wait_putaway { get; set; }

        /// <summary>
        /// 可配库存
        /// </summary>
        public int usable_stock { get; set; }

        /// <summary>
        /// 销售可用库存(聚合)
        /// </summary>
        public int usable_sales { get; set; }

        /// <summary>
        /// 销售可用库存(私有)
        /// </summary>
        public int usable_sales_private { get; set; }

        /// <summary>
        /// 销售可用库存(共享)
        /// </summary>
        public int usable_sales_share { get; set; }

        /// <summary>
        /// 在仓库存(共享)
        /// </summary>
        public int in_warehouse_share { get; set; }

        /// <summary>
        /// 在仓库存(私有)
        /// </summary>
        public int in_warehouse_private { get; set; }

        /// <summary>
        /// 在仓库存(聚合)
        /// </summary>
        public int in_warehouse { get; set; }

        /// <summary>
        /// 仓库占用(共享)
        /// </summary>
        public int occupy_stock_share { get; set; }

        /// <summary>
        /// 仓库占用(私有)
        /// </summary>
        public int occupy_stock_private { get; set; }

        /// <summary>
        /// 仓库占用(聚合)
        /// </summary>
        public int occupy_stock { get; set; }

        /// <summary>
        /// 活动占用
        /// </summary>
        public int occupy_activity { get; set; }

        /// <summary>
        /// 订单占用(私有)
        /// </summary>
        public int occupy_order_private { get; set; }

        /// <summary>
        /// 订单占用(共享)
        /// </summary>
        public int occupy_order_share { get; set; }

        /// <summary>
        /// 订单占用(聚合)
        /// </summary>
        public int occupy_order { get; set; }

        /// <summary>
        /// 环球更新时间
        /// </summary>
        public DateTime update_time { get; set; }

        /// <summary>
        /// 环球创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal shipped_stock { get; set; }
    }

    public class dc_base_stock_dto : dc_base_stock
    {
        /// <summary>
        /// 入库数
        /// </summary>
        public decimal storage_quantity { get; set; }
        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal real_quantity_safe_inventory { get; set; }
        public decimal pack_length { get; set; }
        public decimal pack_width { get; set; }
        public decimal pack_height { get; set; }
        public string brand { get; set; }
        /// <summary>
        /// 可配库存金额
        /// </summary>
        public decimal usable_stock_amount { get; set; }
        /// <summary>
        /// 总在途金额
        /// </summary>
        public decimal on_the_way_stock_amount { get; set; }
        public string product_size { get; set; }
        public string tags { get; set; }
        public string product_type_desc { get; set; }
        public decimal? moq { get; set; }
        /// <summary>
        /// 昨日销量
        /// </summary>
        public decimal? oneday_sales { get; set; }
        /// <summary>
        /// 开发时间
        /// </summary>
        public DateTime? develop_time { get; set; }
        public string base_sku_name { get; set; }
        public string sku_product_inner_code { get; set; }
        public int monitor_status { get; set; }
        public string warehouse_name { get; set; }
        public string sku_name { get; set; }
        /// <summary>
        /// 内部系统采购在途
        /// </summary>
        public int? purchase_daily_quantity { get; set; }

        /// <summary>
        /// 采购员名称
        /// </summary>
        public string buyer_name { get; set; }

        /// <summary>
        /// 产品中文名
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 产品英文名
        /// </summary>
        public string sku_title_en { get; set; }

        /// <summary>
        /// 产品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        /// <summary>
        /// 实时采购在途
        /// </summary>
        public int realtime_quantity_purchase { get; set; }

        /// <summary>
        /// 实时调拨在途
        /// </summary>
        public int realtime_quantity_transfer { get; set; }

        public string suppliers_name { get; set; }

        public decimal? quantity_out_stock { get; set; }

        public DateTime? gmt_out_stock_modified { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        public string has_tort { get; set; }

        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日日均销量
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }
        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales_ebay { get; set; }
        /// <summary>
        /// /// <summary>
        /// 过去14日销量(日均) - ebay
        /// </summary>
        /// </summary>
        public decimal history_fourteenday_sales_ebay { get; set; }
        /// <summary>
        /// /// <summary>
        /// 过去30日销量(日均) - ebay
        /// </summary>
        /// </summary>
        public decimal history_thirtyday_sales_ebay { get; set; }
        public decimal history_sevenday_sales_aliexpress { get; set; }
        public decimal history_fourteenday_sales_aliexpress { get; set; }
        public decimal history_thirtyday_sales_aliexpress { get; set; }
        public decimal history_sevenday_sales_amazon { get; set; }
        public decimal history_fourteenday_sales_amazon { get; set; }
        public decimal history_thirtyday_sales_amazon { get; set; }


        public string category_simple_name { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int? sku_status { get; set; }

        public string sku_status_str { get
            {
                if (sku_status == null) return "";
                return ((sku_status_enum)sku_status).ToString();
            } }

        public enum sku_status_enum
        {
            停售  =1,
            在售 = 2
        }
    }
}
