﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_base_order_data_source
    {
        public long id { get; set; }

        public string order_no { get; set; }
        public string order_type { get; set; }
        public string bailun_sku_warehouse_code { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        public decimal sign_days { get; set; }
        public decimal bale_days { get; set; }
        public decimal put_days { get; set; }
        public string logistics_code { get; set; }
        public string logistics_name { get; set; }
        public string transport_type { get; set; }
        public DateTime? pay_time { get; set; }
        public string pay_type { get; set; }
        public DateTime? confirm_time { get; set; }
        public DateTime? sign_time { get; set; }
        public DateTime? put_time { get; set; }
        public DateTime? shipping_time { get; set; }
        public DateTime? create_date { get; set; }

     
    }

    public class dc_base_order_data_source_dto: dc_base_order_data_source
    {
        public string date_line_str
        {
            get
            {
                if (order_type.Contains("采购单"))
                {
                    if (pay_type == "先货后款")
                    {
                        return $" 创建时间【{create_date}】 ~  采购员确认【{confirm_time}】~ 签收【{sign_time}】 ~ 入库 【{put_time}】  ";
                    }
                    else
                    {
                        return $" 创建时间【{create_date}】 ~  付款【{pay_time}】~ 签收【{sign_time}】 ~ 入库 【{put_time}】  ";
                    }

                }
                else
                {
                    return $" 创建时间【{create_date}】 ~  交运【{shipping_time}】~ 签收【{sign_time}】 ~ 入库 【{put_time}】  ";
                }
            }
        }
    }

    public class dc_base_order_data_source_search_dto
    {
        public  int order_type { get; set; }
        public  string order_type_str { get {
                if (order_type == 11)
                {
                    return "采购单-签收天数计算";
                }
                else if (order_type == 12)
                {
                    return "采购单-质检入库天数计算";
                }
                else if (order_type == 21 || order_type == 22 || order_type == 23 )
                {
                    return "调拨单-平均天数计算";
                }
                else
                {
                    return "";
                }
            } }
        public  string bailun_sku { get; set; }
        public  string warehouse_code { get; set; }
    }
}
