﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 采购建议单
    /// </summary>
    public class dc_auto_purchase_advise
    {
        public int id { get; set; }

        /// <summary>
        /// 流水号
        /// </summary>
        public string no { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 采购建议单号
        /// </summary>
        public string buy_sys_plan_no { get; set; }

        public DateTime? push_time { get; set; }

        /// <summary>
        /// 类型
        /// 1 = 广州03 服装
        /// </summary>
        public int? type { get; set; }

        /// <summary>
        /// 运输方式
        /// </summary>
        public int? sendtype { get; set; }
    }

    /// <summary>
    /// 采购建议流水
    /// </summary>
    public class dc_auto_purchase_advise_detailed
    {
        public int id { get; set; }

        /// <summary>
        /// sku
        /// </summary>
        public string bailun_sku { get; set; }
        public string bailun_sku_warehouse_code { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }
        /// <summary>
        /// 系统建议采购数量
        /// </summary>
        public decimal quantity_init_advise { get; set; }
        /// <summary>
        /// 实际下单数量
        /// </summary>
        public decimal quantity_actual { get; set; }

        /// <summary>
        /// 主表ID
        /// </summary>
        public int main_id { get; set; }

        /// <summary>
        /// 销量趋势预测公式y = kx + b
        /// </summary>
        public string forecast_formula { get; set; }

        /// <summary>
        /// 销量预测公式
        /// </summary>
        public string fit_forecast_formula { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 质检天数
        /// </summary>
        public int inspection_delivery { get; set; }

        /// <summary>
        /// 调拨天数
        /// </summary>
        public int transfer_delivery { get; set; }

        public int sales_upper_limit { get; set; }

        /// <summary>
        /// 是否推送
        /// </summary>
        public int ispush { get; set; }

        /// <summary>
        /// 采购单类型
        /// </summary>
        public int type { get; set; }

        

        /// <summary>
        /// 系统建议数量
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string product_inner_code { get; set; }
        /// <summary>
        /// 商品建议下单数
        /// </summary>
        public decimal goods_quantity_init_advise { get; set; }

        /// <summary>
        /// 商品MOQ
        /// </summary>
        public int goods_moq { get; set; }

        /// <summary>
        /// 商品下所有sku
        /// </summary>
        public string good_sku_codes { get; set; }

        /// <summary>
        /// 商品的最近14日日均销量
        /// </summary>
        public decimal goods_history_fourteenday_sales { get; set; }
        public decimal history_fourteenday_sales { get; set; }


        public int suppliers_id { get; set; }

        public string push_user_name { get; set; }

        /// <summary>
        ///  0 = 其他
        ///  1 = 备安全库存
        ///  2 = 补缺货
        /// </summary>
        public int purchase_type_jit { get; set; }

        /// <summary>
        /// 相关的百伦单号
        /// </summary>
        public string bailun_order_ids { get; set; }

        /// <summary>
        /// 速卖通的实际需求数量
        /// </summary>
        public decimal? quantity_out_stock_aliexpress { get; set; }

        /// <summary>
        /// 亚马逊的实际需求数量
        /// </summary>
        public decimal? quantity_out_stock_amazon { get; set; }

        /// <summary>
        /// 其他平台的需求
        /// </summary>
        public decimal? quantity_out_stock_other { get; set; }
        public string remarks { get; set; }
        /// <summary>
        ///  切换渠道任务id
        /// </summary>
        public int? auto_replace_logistics_task_id { get; set; }

        /// <summary>
        /// 推荐发送的渠道
        /// </summary>
        public string logistics_code { get; set; }
        public string logistics_name { get; set; }

        /// <summary>
        /// 推荐发送的运输方式
        /// </summary>
        public string task_transport_type { get; set; }

        /// <summary>
        /// 物流切换备注
        /// </summary>
        public string replace_logistics_remarks { get; set; }
        /// <summary>
        /// 调拨单在途
        /// </summary>
        public int? quantity_transfer_order { get; set; }

        /// <summary>
        /// 调拨单采购临时数据
        /// </summary>
        public int? quantity_transfer_temp_schedule { get; set; }

        /// <summary>
        /// 调拨在途，暂存
        /// </summary>
        public int? quantity_transfer_temporary_storage { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? fixed_unit_price { get; set; }
        /// <summary>
        /// 历史7天日均
        /// </summary>
        public decimal? fixed_history_sevenday_sales { get; set; }
        /// <summary>
        /// 历史14日均
        /// </summary>
        public decimal? fixed_history_fourteenday_sales { get; set; }
        /// <summary>
        /// 历史30日均
        /// </summary>
        public decimal? fixed_history_thirtyday_sales { get; set; }
        /// <summary>
        /// 加权日均
        /// </summary>
        public decimal? fixed_daily_weighted_sales { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal? fixed_quantity_safe_inventory { get; set; }
        /// <summary>
        /// 今日实际缺货
        /// </summary>
        public decimal? fixed_quantity_out_stock { get; set; }

        /// <summary>
        /// 供应链累积销量
        /// </summary>
        public decimal? fixed_turnover_sales { get; set; }

        /// <summary>
        /// 供应链到货当天的销量
        /// </summary>
        public decimal? fixed_turnover_date_sales { get; set; }

        /// <summary>
        /// 预测销量
        /// </summary>
        public string fixed_sales_explain_details { get; set; }

        /// <summary>
        /// 累积入库数量
        /// </summary>
        public decimal? fixed_turnover_inbound { get; set; }

        /// <summary>
        /// 实际库存
        /// </summary>
        public decimal? fixed_quantity_inventory { get; set; }

        /// <summary>
        /// moq
        /// </summary>
        public decimal? fixed_moq { get; set; }
        /// <summary>
        /// 多备销量
        /// </summary>
        public decimal? fixed_stock_up_sales { get; set; }
        public decimal? fixed_stock_up_days { get; set; }

        /// <summary>
        /// 销量公式
        /// </summary>
        public string fixed_dc_auto_sales_forecast_title { get; set; }


    }



    public enum purchase_type_jit_enum
    {
        其他 = 0,
        备安全库存 = 1,
        补缺货 = 2,
        下首单 =3
    }
    public enum purchase_advise_type_enum
    {
        预计缺货 = 1,
        实际缺货 = 2,
        补货 = 3,
        下首单 = 4
    }

    public class dc_auto_purchase_advise_detailed_buy_dto : dc_auto_purchase_advise_detailed
    {
        /// <summary>
        /// 单价
        /// </summary>
        public decimal unit_price { get; set; }

        /// <summary>
        /// 仓库类型
        /// </summary>
        public string warehouse_type { get; set; }
        /// <summary>
        /// 站点
        /// </summary>
        public string area_name { get; set; }

        /// <summary>
        /// 运输方式
        /// </summary>
        public int? sendtype { get; set; }
    }

    public class dc_auto_purchase_advise_detailed_dto : dc_auto_purchase_advise_detailed
    {
        /// <summary>
        /// 转仓来源仓
        /// </summary>
        public string transfer_warehouse_from_code { get; set; }
        public string transfer_warehouse_from_name { get; set; }
        public decimal quantity_actual_push { get
            {
                if (ispush == 1)
                {
                    return quantity_actual;
                }
                else
                {
                    return 0;
                }
            } }
       public decimal? quantity_actual_amount { get {
                return quantity_actual_push * fixed_unit_price;
            } }
        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public int abroad_inbound_config_delivery { get; set; }
        public string type_str
        {
            get
            {
                return ((purchase_advise_type_enum)type).ToString();
            }
        }
        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal t_history_sevenday_sales { get; set; }
        
        /// <summary>
        /// 过去14日销量(日均)
        /// </summary>
        public decimal t_history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal t_history_thirtyday_sales { get; set; }
        public string source_warehouse_code_name { get; set; }
        public string source_warehouse_code_name_str
        {
            get
            {
                if (string.IsNullOrWhiteSpace(source_warehouse_code_name))
                    return warehouse_name;
                else
                {
                    return source_warehouse_code_name;
                }
            }
        }
        public string warehouse_name { get; set; }

        public string sku_name { get; set; }

        public DateTime create_time { get; set; }

        public string create_time_str { get { return create_time.ToString("yyyy-MM-dd HH:mm"); } }

        /// <summary>
        /// 日均加权销量
        /// </summary>
        public decimal quantity_safe_inventory { get; set; }

        public decimal quantity_out_stock { get; set; }

        public decimal realtime_quantity_out_stock { get; set; }

        public decimal quantity_transfer { get; set; }

        public decimal quantity_purchase { get; set; }

        public decimal quantity_inventory { get; set; }

        public decimal quantity_final_advise_price { get; set; }

        public string suppliers_name { get; set; }

        public string buyer_name { get; set; }

        /// <summary>
        /// 突增关注
        /// </summary>
        public decimal sudden_increase { get; set; }

        /// <summary>
        /// 日均加权
        /// </summary>
        public decimal? daily_weighted_sales { get; set; }

        public string suppliers_link { get; set; }

        public string purchase_type_jit_str { get { return ((purchase_type_jit_enum)purchase_type_jit).ToString();  } }

    }

    public class dc_auto_purchase_advise_detailed_time_dto : dc_auto_purchase_advise_detailed
    {
        public DateTime create_time { get; set; }
    }

    public class dc_auto_purchase_advise_search_dto
    {
        public DateTime? start_date { get; set; }

        public DateTime? end_date { get; set; }

        /// <summary>
        /// 是否推送
        /// </summary>
        public bool? has_push { get; set; }

        /// <summary>
        /// 预计是否断货
        /// </summary>
        public bool? is_outofstock { get; set; }
    }
    public class dc_auto_purchase_advise_detailed_search_dto
    {
        /// <summary>
        /// 数据库类型 0 = 读库，1 = 写库
        /// </summary>
        public int? data_base_type { get; set; }
        /// <summary>
        /// 主表ID
        /// </summary>
        public int main_id { get; set; }

        [Description("sku")]
        public string sku { get; set; }
        [Description("仓库编码")]
        public string warehouse_code { get; set; }
        [Description("开始时间")]
        public DateTime? start_date { get; set; }
        [Description("结束时间")]
        public DateTime? end_date { get; set; }
        [Description("仓库类型")]
        public string warehousetype { get; set; }
        [Description("仓库国家")]
        public int? warehousearea { get; set; }

        /// <summary>
        /// 是否推送
        /// </summary>
        [Description("是否已推送")]
        public bool? ispush { get; set; }

        [Description("类型")]
        public int? type { get; set; }

        /// <summary>
        /// 采购员
        /// </summary>
        [Description("采购员")]
        public string purchase_user { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        [Description("供应商")]
        public string supplier_name { get; set; }

        [Description("商品内部编码")]
        public string product_inner_code { get; set; }

        public bool isSum { get; set; }

        /// <summary>
        /// 是否是同区多仓的sku
        /// </summary>
        public bool is_multiple_warehouse { get; set; }

        [Description("是否有换物流切换建议")]
        public int? is_replace_logistics { get; set; }

        [Description("是否有换物流切换建议")]
        public decimal? quantity_final_advise_price_min { get; set; }

        public decimal? quantity_final_advise_price_max { get; set; }

        [Description("jit备货类型")]
        public int? purchase_type_jit { get; set; }

    }

}
