﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace AutoGeneratePurchaseAdvise
{
    public class GeneratePurchaseAdviseBackgroundService : BackgroundService
    {
        private Timer _timer;
        public DateTime? last_task_date = null;
        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {

            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromSeconds(60));
            return Task.CompletedTask;
        }

        private void DoWork(object state)  
        {
            try
            {
                var now = DateTime.Now;
                if(last_task_date!=null && now.ToString("yyyy-MM-dd HH:mm")== last_task_date.Value.ToString("yyyy-MM-dd HH:mm"))
                {
                    return;
                }
                last_task_date = now;
                //Console.WriteLine($"last_task_date : {last_task_date.Value.ToString("yyyy-MM-dd HH:mm:ss")}"  );

                //if (now.Hour == 5 && now.Minute == 29)
                //{
                //    Console.WriteLine($"开始推送 jit甲油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                //    PurchaseAdviseServices.AutoPushBuySys(1);
                //    Console.WriteLine($"结束推送 jit甲油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                //}

                if (now.Hour == 07 && now.Minute == 01)
                {
                    Console.WriteLine($"开始 刷新路腾仓周转数，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    AutoTurnOver.DB.dc_auto_turnover.ResetSpecialData();
                    Console.WriteLine($"结束 刷新路腾仓周转数，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                }
                // 判断是不是指定的时间
                if (now.Hour == 07 && now.Minute == 2)
                {
                    Console.WriteLine($"开始 检查周转任务状态 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.CheckTurnoveCount(DateTime.Parse(DateTime.Now.ToString("yyyy-MM-dd 00:00:00")));
                    Console.WriteLine($"结束 检查周转任务状态 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 08 && now.Minute == 30)
                {
                    Console.WriteLine($"开始推送 jit甲油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.AutoPushBuySys(1);
                    Console.WriteLine($"结束推送 jit甲油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                }

                if (now.Hour == 08 && now.Minute == 59)
                {
                    // 要上班才推
                    if (ApiServices.GetSchedulings())
                    {
                        Console.WriteLine($"开始推送 服装采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        PurchaseAdviseServices.AutoPushBuySys(2);
                        Console.WriteLine($"结束推送 服装采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        Console.WriteLine($"开始推送 手机采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        PurchaseAdviseServices.AutoPushBuySys(3);
                        Console.WriteLine($"结束推送 手机采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        Console.WriteLine($"开始推送 义乌无库仓采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        PurchaseAdviseServices.AutoPushBuySys(6);
                        Console.WriteLine($"结束推送 义乌无库仓采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        Console.WriteLine($"开始推送 独立站采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        PurchaseAdviseServices.AutoPushBuySys(7);
                        Console.WriteLine($"结束推送 独立站采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    
                }

             
                
                if (now.Hour == 08 && now.Minute == 55)
                {
                    Console.WriteLine($"开始 推送采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.Generate($"早上的全量周转 {DateTime.Now.ToString("HH: mm")}", DateTime.Parse(DateTime.Now.ToString("yyyy-MM-dd 00:00:00")),is_clear_data: true);
                    Console.WriteLine($"结束 推送采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }



                if (now.Hour == 10 && now.Minute == 01)
                {
                    Console.WriteLine($"开始推送 jit精油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.AutoPushBuySys(4);
                    Console.WriteLine($"结束推送 jit精油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }

                if (now.Hour == 10 && now.Minute == 05) // LM仓库采购建议
                {
                    Console.WriteLine($"开始推送 jit精油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.AutoPushBuySys(8);
                    Console.WriteLine($"结束推送 jit精油采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }

                if (now.Hour == 13 && now.Minute == 01)
                {
                    // 要上班才推
                    if (ApiServices.GetSchedulings())
                    {
                        Console.WriteLine($"开始推送 义乌无库仓采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        PurchaseAdviseServices.AutoPushBuySys(6);
                        Console.WriteLine($"结束推送 义乌无库仓采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }

                }

                if (now.Hour == 16 && now.Minute == 01)
                {
                    // 要上班才推
                    if (ApiServices.GetSchedulings())
                    {
                        Console.WriteLine($"开始推送 服装采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        //PurchaseAdviseServices.AutoPushBuySys(5);
                        PurchaseAdviseServices.AutoPushBuySys(2);
                        Console.WriteLine($"结束推送 服装采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        Console.WriteLine($"开始推送 独立站采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        PurchaseAdviseServices.AutoPushBuySys(7);
                        Console.WriteLine($"结束推送 独立站采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                    }

                }

                if (now.Hour == 14 && now.Minute == 30)
                {
                    Console.WriteLine($"开始 检查周转任务状态 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.CheckTurnoveCount(DateTime.Parse(DateTime.Now.ToString("yyyy-MM-dd 12:00:00")));
                    Console.WriteLine($"结束 检查周转任务状态 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                // 判断是不是指定的时间
                if (now.Hour == 15 && now.Minute == 2)
                {
                    Console.WriteLine($"开始 推送采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAdviseServices.Generate($"下午的补充周转 {DateTime.Now.ToString("HH: mm")}", DateTime.Parse(DateTime.Now.ToString("yyyy-MM-dd 12:00:00")));
                    Console.WriteLine($"结束 推送采购建议 任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }


                if (now.Hour == 14 && now.Minute == 02)
                {
                    // 要上班才推
                    if (ApiServices.GetSchedulings())
                    {
                        Console.WriteLine($"开始推送 服装采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        PurchaseAdviseServices.AutoPushBuySys(2);
                        Console.WriteLine($"结束推送 服装采购建议任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }

                }

                //if (now.Hour == 7 && now.Minute == 29)
                //{
                //    Console.WriteLine($"开始推送 国内仓实时库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                //    new DailyServices().GenerateData();
                //    Console.WriteLine($"结束推送 国内仓实时库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                //}


            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
