﻿using AutoTurnOver.Models.Base;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 销量预测配置模型
    /// </summary>
    public class dc_auto_sales_forecast_config
    {
        public int id { get; set; }
        public string title { get; set; }
        /// <summary>
        /// 仓库类型，可以留空 例：中国仓, dc_base_warehouse.hq_type
        /// </summary>
        public string warehouse_type { get; set; }

        /// <summary>
        /// 国家，可以留空 例：美国，dc_base_warehouse.area_name
        /// </summary>
        public string warehouse_area_id { get; set; }

        /// <summary>
        /// 仓库编码，可以留空 dc_base_warehouse.warehouse_code 
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 类目，例：推荐普货 dc_base_sku.product_type
        /// </summary>
        public string category { get; set; }

        public DateTime create_date { get; set; }
        public int level { get; set; }
        public int is_delete { get; set; }

        /// <summary>
        /// 筛选类型 1 =根据入库时间筛选 2 = 根据销量筛选
        /// </summary>
        public int screen_type { get; set; }
    }

    public class dc_auto_sales_forecast_stage_config
    {
        public int id { get; set; }
        public int config_id { get; set; }
        public int index { get; set; }
        /// <summary>
        /// 首次入库距今多少时长，0 代表未配置。首次入库取值：dc_base_stock.first_inbound_date
        /// </summary>
        public int duration_upper_limit { get; set; }
        public int duration_lower_limit { get; set; }

        /// <summary>
        /// 销量上限，例：10.1，加权日均销量 <= 10.1; dc_auto_turnover.daily_weighted_sales (注意：这个字段正是周转算法要算的不能直接取)
        /// </summary>
        public decimal sales_upper_limit { get; set; }

        /// <summary>
        /// 销量下限，例：0 加权日均销量 >= 0; dc_auto_turnover.daily_weighted_sales
        /// </summary>
        public decimal sales_lower_limit { get; set; }

        /// <summary>
        /// 阶段一的比例，例：0.33 代表 从今天 ~ （供应链长度*0.33）天 的日期全部采用第一阶段的算法；
        /// </summary>
        public decimal one_ratio { get; set; }

        /// <summary>
        /// 阶段二的比例，例：0.33 代表 从第一阶段的最后一天 ~ （供应链长度*0.33）天 的日期全部采用第二阶段的算法；
        /// </summary>
        public decimal two_ratio { get; set; }

        /// <summary>
        /// 阶段三的比例，例：0.33 代表 从第二阶段的最后一天 ~ （供应链长度*0.33）天 的日期全部采用第三阶段的算法
        /// </summary>
        public decimal three_ratio { get; set; }
        public decimal one_n1 { get; set; }
        public decimal one_n2 { get; set; }
        public decimal one_n3 { get; set; }
        public decimal one_n4 { get; set; }
        public decimal one_n5 { get; set; }
        public decimal one_n6 { get; set; }

        public decimal two_n1 { get; set; }
        public decimal two_n2 { get; set; }
        public decimal two_n3 { get; set; }
        public decimal two_n4 { get; set; }
        public decimal two_n5 { get; set; }
        public decimal two_n6 { get; set; }

        public decimal three_n1 { get; set; }
        public decimal three_n2 { get; set; }
        public decimal three_n3 { get; set; }
        public decimal three_n4 { get; set; }
        public decimal three_n5 { get; set; }
        public decimal three_n6 { get; set; }
    }

    public class dc_auto_sales_forecast_config_dto: dc_auto_sales_forecast_config
    {
        public string bailun_skus { get; set; }
        public string warehouse_name { get; set; }

        public List<dc_auto_sales_forecast_stage_config> stages { get; set; }
    }



    public class dc_auto_sales_forecast_config_search_dto: page_search_dto
    {
        public string bailun_sku { get; set; }
        public string warehousetype { get; set; }
        public int? warehousearea { get; set; }
        public string warehouse_code { get; set; }
        public int? is_delete { get; set; }
    }

    public class dc_auto_sales_forecast_sku_config
    {
        public int id { get; set; }
        public int config_id { get; set; }
        public string bailun_sku { get; set; }
    }
}
