﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 下首单的sku
    /// </summary>
    public class dc_auto_first_order_sku
    {
        public int id { get; set; }
        public string bailun_sku { get; set; }
        public DateTime push_date { get; set; }
        public string warehouse_code { get; set; }
        /// <summary>
        /// 运输方式 1=陆运 2=海运 3=空运 4=铁路运输
        /// </summary>
        public int sendtype { get; set; }
        public DateTime order_time { get; set; }

        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string product_inner_code { get; set; }

        /// <summary>
        /// 商品日均销量
        /// </summary>
        public decimal product_sales { get; set; }

        /// <summary>
        /// 开发来源
        /// </summary>
        public int source { get; set; }

        /// <summary>
        /// 品牌
        /// </summary>
        public string brand { get; set; }
        public int is_error { get; set; }
    }

    public class dc_auto_first_order_sku_input_dto
    {
        public string warehouse_code { get; set; }

        public int sendtype { get; set; }

        public List<dc_auto_first_order_sku_input_dto_detailed_dto> detailed { get; set; }

        
    }

    public class dc_auto_first_order_sku_input_dto_detailed_dto
    {

        public string bailun_sku { get; set; }
        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string product_inner_code { get; set; }

        /// <summary>
        /// 商品日均销量
        /// </summary>
        public decimal product_sales { get; set; }

        /// <summary>
        /// 开发来源
        /// </summary>
        public int source { get; set; }

        /// <summary>
        /// 品牌
        /// </summary>
        public string brand { get; set; }
    }

    /// <summary>
    /// 自动下单明细
    /// </summary>
    public class auto_first_order_detailed_dto
    {
        public string bailun_sku { get; set; }
        public decimal quantity { get; set; }
        public decimal share_quantity { get; set; }

        public StringBuilder remarks { get; set; }
    }

}
