﻿using AutoTurnOver.Models.ApiDto;
using AutoTurnOver.Utility;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.DB
{
    public class ApiUtility
    {
        /// <summary>
        /// 批量修改sku默认发货仓
        /// </summary>
        public static void SaveDefaultWares(List<SaveDefaultWaresRequestDto> datas)
        {
            try
            {
                //查询采购建议明细 
                string url = ConfigHelper.GetValue("SaveDefaultWares");
                string resultStr = HttpHelper.Request(url, RequestType.POST, datas.ToJson(), "application/json", timeout: 1000 * 60 * 60 * 24);
                var result = resultStr.ToObj<SaveDefaultWaresResponseDto>();
                if (result == null)
                {
                    throw new Exception("skums 系统异常： 推送失败");
                }
                if (result.statusCode != 200)
                {
                    throw new Exception("skums 系统异常： " + result.message);
                }
            }
            catch (Exception ex)
            {
                throw new Exception("skums 系统异常： " + ex.Message);
            }

            return;
        }
    }
}
