﻿using System;
using System.Collections.Generic;
using System.Text;
using AutoTurnOver.Models;
using System.Linq;

namespace AutoTurnOver.Services
{
    /// <summary>
    /// 自动周转
    /// </summary>
    public class SkuAutoTurnServices
    {
        /// <summary>
        /// 获取自动周转分页
        /// </summary>
        /// <param name="page">当前页</param>
        /// <param name="pagesize">每页记录数</param>
        /// <param name="total">符合条件的总记录数</param>
        /// <param name = "order" > 排序类型 </ param >
        /// <param name="sort">排序字段</param>
        /// <returns></returns>
        public List<dc_auto_turnover_Extend> List(Condition_AutoTurnOver m,int offset, int limit, ref int total,string order="",string sort="",bool isSum = false)
        {
            if (!string.IsNullOrWhiteSpace(m.categoryIds))
            {
                m.categoryModels = ApiServices.GetClientNodesByIds(m.categoryIds.Split(',').Select(s=>int.Parse(s)).ToList());
            }
            return DB.dc_auto_turnover.List(m,offset, limit, ref total,order,sort, isSum);
        }

        #region 特殊销售设置

        /// <summary>
        /// 获取特殊销售设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_promotion> List(Condition_ConfigPromotion m, int offset, int limit,ref int total)
        {
            return DB.dc_auto_turnover.ListConfigPromotion(m, offset, limit,ref total);
        }

        /// <summary>
        /// 查询未来指定时间范围内的特殊销量数据
        /// </summary>
        /// <param name="days"></param>
        /// <returns></returns>
        public IEnumerable<dc_auto_config_promotion> List(string sku,string warehousecode,int days)
        {
            var now = DateTime.Now;
            return DB.dc_auto_turnover.ListConfigPromotion(sku, warehousecode, now, now.AddDays(days));
        }


        /// <summary>
        /// 保存销售设置
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveSaleSetting(Models.dc_auto_config_promotion m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.bailun_sku))
            {
                return "Sku不能为空！";
            }

            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            if (m.count <= 0)
            {
                return "增量必须大于0！";
            }

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }

            m.warehouse_name = objWarehouse.warehouse_name;

            if (m.promotion_time < DateTime.Parse(DateTime.Now.ToShortDateString()).AddDays(1))
            {
                return "销售日期必须大于今天！";
            }

            return DB.dc_auto_turnover.SaveSaleSetting(m, username);
        }

        public void AddsSaleSetting(List<dc_auto_config_promotion_input> datas)
        {
            foreach (var m in datas)
            {
                if (string.IsNullOrWhiteSpace(m.sku))
                {
                    throw new Exception("Sku不能为空！");
                }

                if (string.IsNullOrWhiteSpace(m.warehousecode))
                {
                    throw new Exception("请选择仓库！");
                }

                if (m.count <= 0)
                {
                    throw new Exception("增量必须大于0！");
                }

                var objWarehouse = DB.common.GetWareHouseByCode(m.warehousecode);
                if (objWarehouse == null)
                {
                    throw new Exception("系统找不到该仓库");
                }

                m.warehouse_name = objWarehouse.warehouse_name;

                if (m.time < DateTime.Parse(DateTime.Now.ToShortDateString()).AddDays(1))
                {
                    throw new Exception("销售日期必须大于今天");
                }
            }
            

            DB.dc_auto_turnover.AddsSaleSetting(datas);
        }

        /// <summary>
        /// 获取特殊销售设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_promotion GetSaleSettingById(int id)
        {
            return DB.dc_auto_turnover.GetSaleSettingById(id);
        }

        #endregion

        #region 市场因素设置

        /// <summary>
        /// 获取市场因素设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_config_correction> CorrectionList(Condition_ConfigPromotion m, int offset, int limit, ref int total)
        {
            return DB.dc_auto_turnover.ListCorrection(m, offset, limit, ref total);
        }

        /// <summary>
        /// 查询未来指定时间范围内的特殊销量数据
        /// </summary>
        /// <param name="days"></param>
        /// <returns></returns>
        public IEnumerable<dc_auto_config_correction> CorrectionList(string sku, string warehousecode, int days)
        {
            var now = DateTime.Now;
            return DB.dc_auto_turnover.ListCorrection(sku, warehousecode, now, now.AddDays(days));
        }


        /// <summary>
        /// 保存销售设置
        /// </summary>
        /// <param name="m">销售设置model</param>
        /// <param name="username">当前操作人</param>
        /// <returns></returns>
        public string SaveCorrection(Models.dc_auto_config_correction m, string username)
        {
            if (string.IsNullOrWhiteSpace(m.bailun_sku))
            {
                return "Sku不能为空！";
            }

            if (string.IsNullOrWhiteSpace(m.warehouse_code))
            {
                return "请选择仓库！";
            }

            if (m.param <= 0)
            {
                return "比例必须大于0！";
            }

            var objWarehouse = DB.common.GetWareHouseByCode(m.warehouse_code);
            if (objWarehouse == null)
            {
                return "系统找不到该仓库。";
            }

            m.warehouse_name = objWarehouse.warehouse_name;

            if (m.start_time < DateTime.Parse(DateTime.Now.ToShortDateString()).AddDays(1))
            {
                return "开始时间必须大于今天！";
            }

            if (m.end_time < DateTime.Parse(DateTime.Now.ToShortDateString()).AddDays(1))
            {
                return "结束时间必须大于今天！";
            }

            if (DateTime.Parse(m.end_time.ToShortDateString()) < DateTime.Parse(m.start_time.ToShortDateString()))
            {
                return "结束时间不能小于开始时间！";
            }


            return DB.dc_auto_turnover.SaveCorrection(m, username);
        }

        

        /// <summary>
        /// 获取市场因素设置详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public dc_auto_config_correction GetCorrectionById(int id)
        {
            return DB.dc_auto_turnover.GetCorrectionById(id);
        }

        #endregion

        #region 预估库存

        /// <summary>
        /// 获取预估库存详情
        /// </summary>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <returns></returns>
        public dc_auto_inventory GetAutoInventoryBySkuWH(string sku,string warehousecode)
        {
            return DB.dc_auto_turnover.GetAutoInventoryBySkuWH(sku, warehousecode);
        }

        #endregion

        public dc_auto_turnover GetModel(string sku, string wCode)
        {
            return DB.dc_auto_turnover.GetModel(sku, wCode);
        }

    }
}
