﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    ///  异常报警
    /// </summary>
    public class dc_auto_forecast_fluctuation
    {
        public int id { get; set; }

        public DateTime gmt_create { get; set; }

        public DateTime gmt_modified { get; set; }

        public string bailun_sku { get; set; }

        public string warehouse_code { get; set; }

        public string warehouse_name { get; set; }


        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime start_time { get; set; }

        public DateTime end_time { get; set; }

        /// <summary>
        /// 操作人
        /// </summary>
        public string bl_operator { get; set; }

        /// <summary>
        /// 处理办法
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 是否解决
        /// </summary>
        public int has_solve { get; set; }

        /// <summary>
        /// 预计解决时间
        /// </summary>
        public DateTime? forecast_solve_time { get; set; }

        /// <summary>
        /// 是否确认
        /// </summary>
        public int? has_confirm { get; set; }

        public int type { get; set; }

        public string typeStr
        {
            get
            {
                return ((type_enum)type).ToString();
            }

        }

        public enum type_enum
        {
            实际缺货  =1,
            预计缺货 = 2,
            实际冗余 = 3,
            预计冗余 = 4
        }

        /// <summary>
        /// 最近3日销量
        /// </summary>
        public decimal avg_sales_three { get; set; }
    }

    public class dc_auto_forecast_fluctuation_search_dto
    {
        public string sku { get; set; }
        public string warehouse_code { get; set; }

        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }
        /// <summary>
        /// 数据是否过期
        /// </summary>
        public bool? has_overdue { get; set; }
        /// <summary>
        /// 是否已确认
        /// </summary>
        public bool? has_confirm { get; set; }

        /// <summary>
        /// 是否已解决
        /// </summary>
        public bool? has_solve { get; set; }

        /// <summary>
        /// 异常类型
        /// </summary>
        public int? err_type { get; set; }
    }

    
}
