﻿using AutoTurnOver.Models;
using Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.DB
{
    public class daily : connectionHelper
    {
        /// <summary>
        /// 查询采购在途数据
        /// </summary>
        /// <param name="sku">sku</param>
        /// <param name="warehouse_code">仓库编码</param>
        /// <returns></returns>
        public static IEnumerable<dc_purchase_daily_dto> List(string sku, string warehouse_code)
        {
            var sql = @" 
SELECT
	tb1.bailun_sku AS bailun_sku,
	tb1.warehouse_code AS warehouse_code,
	tb1.purchase_id AS purchase_id,
     tb1.estimated_arrival_time AS estimated_arrival_time,
	-- tb1.has_transfer AS has_transfer,
	sum( ( tb1.count - IFNULL( tb2.count, 0 ) ) ) AS dailyQuantity ,
		(case when t_w.hq_type='fba仓' then t_w.bailun_account else t_w.warehouse_name end)  as warehouse_name
FROM
	(
SELECT
	bailun_sku,
	warehouse_code,
	parent_id,
	purchase_id,
	estimated_arrival_time,
	has_transfer,
	sum( count ) AS count 
FROM
	dc_base_purchase 
WHERE
	buy_status IN ( 0, 1, 2, 3 ) 
	AND has_delete = 0 
	AND bailun_sku = @bailun_sku
	AND warehouse_code = @warehouse_code
GROUP BY
	bailun_sku,
	parent_id 
	) tb1
	LEFT JOIN ( SELECT bailun_sku, warehouse_code, parent_id, sum( count ) AS count FROM dc_base_purchase_inbound GROUP BY bailun_sku, parent_id ) tb2 ON tb1.bailun_sku = tb2.bailun_sku 
	AND tb1.parent_id = tb2.parent_id 
left join dc_base_warehouse as t_w on tb1.warehouse_code = t_w.warehouse_code
GROUP BY
	tb1.bailun_sku,
	tb1.warehouse_code,
	tb1.purchase_id
";
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("bailun_sku", sku);
            parameters.Add("warehouse_code", warehouse_code);
            return _connection.Query<dc_purchase_daily_dto>(sql, parameters);
        }

        // <summary>
        /// 查询调拨在途数据
        /// </summary>
        /// <param name="sku">sku</param>
        /// <param name="warehouse_code">仓库编码</param>
        /// <returns></returns>
        public static IEnumerable<dc_transfer_daily_dto> TransferList(string sku, string warehouse_code)
        {
            var sql = @" 
SELECT
	tb5.bailun_sku bailun_sku,
	tb5.warehouse_code warehouse_code,
	tb5.transfer_order_id transfer_order_id,
	tb5.estimated_arrival_time estimated_arrival_time,
	tb5.create_time create_time,
	( tb5.count - IFNULL( tb4.count, 0 ) ) AS count ,
	(case when t_w.hq_type='fba仓' then t_w.bailun_account else t_w.warehouse_name end)  as warehouse_name
FROM
	(
SELECT
	tb1.bailun_sku,
	tb1.warehouse_code,
	tb1.transfer_order_id,
	tb1.estimated_arrival_time,
	tb1.create_time,
	sum( tb1.count ) count 
FROM
	dc_base_transfer_verify tb1
	LEFT JOIN dc_base_transfer_complete tb2 ON tb1.deleted = tb2.deleted 
	AND tb1.bailun_sku = tb2.bailun_sku 
	AND tb1.warehouse_code = tb2.warehouse_code 
	AND tb1.transfer_order_id = tb2.transfer_order_id 
WHERE
	tb2.bailun_sku IS NULL 
	AND tb1.bailun_sku = @bailun_sku
	
	AND tb1.warehouse_code = @warehouse_code
	
	AND tb1.deleted = 0 
GROUP BY
	bailun_sku,
	warehouse_code,
	transfer_order_id 
	) tb5
LEFT JOIN (
	SELECT
		bailun_sku,
		warehouse_code,
		transfer_order_id,
		sum( count ) count 
	FROM
		(
		SELECT
			tb1.bailun_sku,
			tb1.warehouse_code,
			max( tb1.count ) count,
			tb1.transfer_order_id 
		FROM
			dc_base_transfer_inbound tb1
			LEFT JOIN dc_base_transfer_complete tb2 ON tb2.deleted = 0 
			AND tb1.bailun_sku = tb2.bailun_sku 
			AND tb1.warehouse_code = tb2.warehouse_code 
			AND tb1.transfer_order_id = tb2.transfer_order_id 
		WHERE
			tb2.bailun_sku IS NULL 
			AND tb1.deleted = 0 
		GROUP BY
			bailun_sku,
			warehouse_code,
			transfer_order_id 
		) tb3 
	GROUP BY
		bailun_sku,
		warehouse_code,
		transfer_order_id 
	) tb4 ON tb5.bailun_sku = tb4.bailun_sku 
AND tb5.warehouse_code = tb4.warehouse_code 
AND tb5.transfer_order_id = tb4.transfer_order_id 
left join dc_base_warehouse as t_w on tb5.warehouse_code = t_w.warehouse_code
WHERE
( tb5.count - IFNULL( tb4.count, 0 ) ) > 0
";
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("bailun_sku", sku);
            parameters.Add("warehouse_code", warehouse_code);
            return _connection.Query<dc_transfer_daily_dto>(sql, parameters);
        }


        /// <summary>
        /// 查询时实库存数据
        /// </summary>
        /// <param name="sku">sku</param>
        /// <param name="warehouse_code">仓库编码</param>
        /// <returns></returns>
        public static IEnumerable<dc_base_stock_dto> RealtimeList(string sku, string warehouse_code, string product_inner_code, string sku_title_cn, int offset, int limit, ref int total, string warehousetype, int? warehousearea)
        {
            var sql = @" 
 select
(case when dbw.hq_type='fba仓' then dbw.bailun_account else dbw.warehouse_name end)  as warehouse_name,
t3.sku_title_cn as 'sku_name',
t4.quantity_purchase as 'purchase_daily_quantity',
t3.buyer_name,t3.sku_title_cn,t3.sku_title_en,t3.product_inner_code,
t4.quantity_purchase as 'realtime_quantity_purchase',t4.quantity_transfer as 'realtime_quantity_transfer',
t_base.bailun_sku,t_base.warehouse_code,
t1.*
from 
(SELECT
 t1.warehouse_code,t1.bailun_sku 
FROM
 dc_mid_transit AS t1
 
union

SELECT
  t1.warehouse_code,t1.bailun_sku 
FROM
 dc_base_stock AS t1
 ) as t_base
left join dc_base_stock as t1 on t_base.bailun_sku = t1.bailun_sku and t_base.warehouse_code = t1.warehouse_code
left join dc_base_sku as t3 on t_base.bailun_sku = t3.bailun_sku
left join dc_base_warehouse as dbw on t_base.warehouse_code = dbw.warehouse_code
left join dc_mid_transit as t4  on t_base.bailun_sku = t4.bailun_sku and t_base.warehouse_code = t4.warehouse_code
where 1=1
";

            var countSql = @" 
 select
count(1)
from 
(SELECT
 t1.warehouse_code,t1.bailun_sku 
FROM
 dc_mid_transit AS t1
 union
SELECT
  t1.warehouse_code,t1.bailun_sku 
FROM
 dc_base_stock AS t1
 ) as t_base
left join dc_base_stock as t1 on t_base.bailun_sku = t1.bailun_sku and t_base.warehouse_code = t1.warehouse_code
left join dc_base_sku as t3 on t_base.bailun_sku = t3.bailun_sku
left join dc_base_warehouse as dbw on t_base.warehouse_code = dbw.warehouse_code
left join dc_mid_transit as t4  on t_base.bailun_sku = t4.bailun_sku and t_base.warehouse_code = t4.warehouse_code
where 1=1
";
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("time", DateTime.Now.ToString("yyyy-MM-dd 00:00:00"));

            if (!string.IsNullOrWhiteSpace(warehousetype))
            {
                sql += " and dbw.hq_type = @hq_type ";
                countSql += " and dbw.hq_type = @hq_type ";

                parameters.Add("hq_type", warehousetype);
            }
            if (warehousearea>0)
            {
                sql += " and dbw.area_id = @area_id ";
                countSql += " and dbw.area_id = @area_id ";

                parameters.Add("area_id", warehousearea);
            }

            if (!string.IsNullOrWhiteSpace(product_inner_code))
            {
                sql += " and t3.product_inner_code like @product_inner_code ";
                countSql += " and t3.product_inner_code like @product_inner_code ";

                parameters.Add("product_inner_code", $"%{product_inner_code}%");
            }
            if (!string.IsNullOrWhiteSpace(sku_title_cn))
            {
                sql += " and t3.sku_title_cn like @sku_title_cn ";
                countSql += " and t3.sku_title_cn like @sku_title_cn ";

                parameters.Add("sku_title_cn", $"%{sku_title_cn}%");
            }
            if (!string.IsNullOrWhiteSpace(sku))
            {
                sql += " and t_base.bailun_sku in @bailun_skus ";
                countSql += " and t_base.bailun_sku in @bailun_skus ";

                parameters.Add("bailun_skus", sku.Split(','));
            }
            if (!string.IsNullOrWhiteSpace(warehouse_code))
            {
                sql += " and t_base.warehouse_code=@warehouse_code ";
                countSql += " and t_base.warehouse_code=@warehouse_code ";
                parameters.Add("warehouse_code", warehouse_code);
            }


            var obj = _connection.Query<dc_base_stock_dto>(sql + " limit " + offset + "," + limit, parameters,buffered:false,commandTimeout:0);
            total = _connection.QueryFirst<int>(countSql, parameters);
            return obj.AsList();
        }

    }
}
