﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_auto_return_goods_sku
    {
        public int id { get; set; }
        public string bailun_sku { get; set; }
        public int order_id { get; set; }
        /// <summary>
        /// 审批时间
        /// </summary>
        public DateTime approval_date { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public int config_id { get; set; }
        public string config_name { get; set; }
        public DateTime create_date { get; set; }
        public string monitor_status { get; set; }
        public string sku_title { get; set; }
        public int suppliers_id { get; set; }
        /// <summary>
        /// 供应商名称
        /// </summary>
        public string suppliers_name { get; set; }
        /// <summary>
        /// 单价
        /// </summary>
        public decimal unit_price { get; set; }
        /// <summary>
        /// 可用库存
        /// </summary>
        public decimal stock { get; set; }
        /// <summary>
        /// 库存金额
        /// </summary>
        public decimal stock_amount { get; set; }
        /// <summary>
        /// 7 日日均销量
        /// </summary>
        public decimal sales_average_7 { get; set; }
        /// <summary>
        /// 14 日日均销量
        /// </summary>
        public decimal sales_average_14 { get; set; }
        /// <summary>
        /// 加权日均销量
        /// </summary>
        public decimal sales_average_weight { get; set; }
        /// <summary>
        /// 退货数量
        /// </summary>
        public decimal retun_quantity { get; set; }
        /// <summary>
        /// 待审核=0, 已审核=1, 驳回=-1
        /// </summary>
        public decimal status { get; set; }
        public string approval_remarks { get; set; }
        /// <summary>
        /// 未推送= 0，已推送=1
        /// </summary>
        public int oms_push_status { get; set; }
        /// <summary>
        /// 未出库=0 ， 已出库=1
        /// </summary>
        public int oms_out_status { get; set; }
        /// <summary>
        /// 未推送= 0，已推送=1
        /// </summary>
        public int no_library_sys_push_status { get; set; }
        /// <summary>
        /// 未出库=0 ， 已出库=1
        /// </summary>
        public int no_library_sys_out_status { get; set; }
    }

    public class dc_auto_return_goods_sku_dto: dc_auto_return_goods_sku
    {
        public string monitor_status_str { get; set; }
        public string status_str { get
            {
                return ((dc_auto_return_goods_sku_status_enum)status).ToString();
            } }
        public string push_status_str
        {
            get
            {
                var str="";
                if (oms_push_status == 1)
                {
                    str += "已推送";
                }
                else
                {
                    str += "未推送";
                }

                if (oms_out_status == 1)
                {
                    str += "已出库";
                }
                else
                {
                    str += "未出库";
                }
                return str;
            }
        }
    }

    public class dc_auto_return_goods_sku_search_dto
    {
        public int? offset { get; set; }
        public int? limit { get; set; }
        public int? monitor_status { get; set; }
        public int? status { get; set; }
        public int? oms_out_status { get; set; }
        public int? no_library_sys_push_status { get; set; }
        public string supplier_name { get; set; }
        public string warehouse_code { get; set; }
        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }
        public string sku { get; set; }
        public DateTime? btime { get; set; }
        public DateTime? etime { get; set; }
    }

    public enum dc_auto_return_goods_sku_status_enum
    {
        待审核 = 0, 已审核 = 1, 驳回 = -1
    }

}
