﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_auto_pick_up_goods_order
    {
        public int id { get; set; }
        public string no { get; set; }
        public DateTime date { get; set; }
        public DateTime create_date { get; set; }
        public DateTime? pay_time { get; set; }
        public DateTime? order_1688_time { get; set; }
        public string pick_up_goods_time { get; set; }
        public string purchase_id { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public int suppliers_id { get; set; }
        public string suppliers_name { get; set; }
        public string address { get; set; }
        public string pick_up_user { get; set; }
        public string pick_up_tel { get; set; }
    }

    public class dc_auto_pick_up_goods_order_sku
    {
        public int id { get; set; }
        public int main_id { get; set; }
        public string bailun_sku { get; set; }
        public string sku_name { get; set; }
        public decimal price { get; set; }
        public int quantity { get; set; }

        /// <summary>
        /// 单价(总)
        /// </summary>
        public decimal amount { get; set; }
    }


    /// <summary>
    /// 提货单
    /// </summary>
    public class dc_auto_pick_up_goods_order_view_dto
    {
        public int id { get; set; }
        public string no { get; set; }
        public DateTime date { get; set; }
        public string date_str { get { return date.ToString("yyyy-MM-dd"); } }
        public DateTime? pay_time { get; set; }
        public DateTime? order_1688_time { get; set; }
        public string pick_up_goods_time { get; set; }
        public string purchase_id { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public string bailun_sku { get; set; }
        public string sku_name { get; set; }
        public decimal price { get; set; }
        public int quantity { get; set; }

        /// <summary>
        /// 单价(总)
        /// </summary>
        public decimal amount { get; set; }
    }

    public class dc_auto_pick_up_goods_order_search_dto
    {
        public string warehouse_code { get; set; }
        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }
    }

    public class api_push_SupplierAimsUpSkuInfoDto
    {
        /// <summary>
        /// 供应商名称
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// 供应商ID
        /// </summary>
        public long SupplierId { get; set; }

        /// <summary>
        /// 提货单号
        /// </summary>
        public string PickUpNo { get; set; }

        /// <summary>
        /// sku编码
        /// </summary>
        public string Sku { get; set; }
        /// <summary>
        /// sku名称
        /// </summary>
        public string SkuTitle { get; set; }
        /// <summary>
        /// 地址
        /// </summary>
        public string Address { get; set; }
        /// <summary>
        /// 取货对接人
        /// </summary>
        public string PickUpUser { get; set; }
        /// <summary>
        /// 对接人电话
        /// </summary>
        public string PickUpTel { get; set; }
        /// <summary>
        /// 仓库名称
        /// </summary>
        public string WarehouseName { get; set; }

        /// <summary>
        /// 日期
        /// </summary>
        public DateTime PickTime { get; set; }
        /// <summary>
        /// 单价
        /// </summary>
        public decimal? Price { get; set; }

        /// <summary>
        /// 下单数
        /// </summary>
        public int? CheckSale { get; set; }
        /// <summary>
        /// 供应商总下单数
        /// </summary>
        public int? SupplierCheckSale { get; set; }
        /// <summary>
        /// 总下单金额
        /// </summary>
        public decimal? CheckGMV { get; set; }

        /// <summary>
        /// 当日缺货数
        /// </summary>
        public decimal DayOutStock { get; set; }

        /// <summary>
        /// 供应商最晚提货时间
        /// </summary>
        public string LatestPickUpTime { get; set; }

        /// <summary>
        /// 下单时间
        /// </summary>
        public DateTime? CheckTime { get; set; }
    }
}
